/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.ptg.ControlPtg;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class AttrPtg
extends ControlPtg {
    public static final byte sid = 25;
    private static final int SIZE = 4;
    private final byte _options;
    private final short _data;
    private final int[] _jumpTable;
    private final int _chooseFuncOffset;
    private static final BitField semiVolatile = BitFieldFactory.getInstance(1);
    private static final BitField optiIf = BitFieldFactory.getInstance(2);
    private static final BitField optiChoose = BitFieldFactory.getInstance(4);
    private static final BitField optiSkip = BitFieldFactory.getInstance(8);
    private static final BitField optiSum = BitFieldFactory.getInstance(16);
    private static final BitField baxcel = BitFieldFactory.getInstance(32);
    private static final BitField space = BitFieldFactory.getInstance(64);
    public static final AttrPtg SUM = new AttrPtg(16, 0, null, -1);

    public AttrPtg(LittleEndianInput littleEndianInput) {
        this._options = littleEndianInput.readByte();
        this._data = littleEndianInput.readShort();
        if (this.isOptimizedChoose()) {
            short s = this._data;
            int[] nArray = new int[s];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = littleEndianInput.readUShort();
            }
            this._jumpTable = nArray;
            this._chooseFuncOffset = littleEndianInput.readUShort();
        } else {
            this._jumpTable = null;
            this._chooseFuncOffset = -1;
        }
    }

    private AttrPtg(int n, int n2, int[] nArray, int n3) {
        this._options = (byte)n;
        this._data = (short)n2;
        this._jumpTable = nArray;
        this._chooseFuncOffset = n3;
    }

    public static AttrPtg createSpace(int n, int n2) {
        int n3 = n & 0xFF | n2 << 8 & 0xFFFF;
        return new AttrPtg(space.set(0), n3, null, -1);
    }

    public static AttrPtg createIf(int n) {
        return new AttrPtg(optiIf.set(0), n, null, -1);
    }

    public static AttrPtg createSkip(int n) {
        return new AttrPtg(optiSkip.set(0), n, null, -1);
    }

    public static AttrPtg getSumSingle() {
        return new AttrPtg(optiSum.set(0), 0, null, -1);
    }

    public boolean isSemiVolatile() {
        return semiVolatile.isSet(this._options);
    }

    public boolean isOptimizedIf() {
        return optiIf.isSet(this._options);
    }

    public boolean isOptimizedChoose() {
        return optiChoose.isSet(this._options);
    }

    public boolean isSum() {
        return optiSum.isSet(this._options);
    }

    public boolean isSkip() {
        return optiSkip.isSet(this._options);
    }

    private boolean isBaxcel() {
        return baxcel.isSet(this._options);
    }

    public boolean isSpace() {
        return space.isSet(this._options);
    }

    public short getData() {
        return this._data;
    }

    public int[] getJumpTable() {
        return (int[])this._jumpTable.clone();
    }

    public int getChooseFuncOffset() {
        if (this._jumpTable == null) {
            throw new IllegalStateException("Not tAttrChoose");
        }
        return this._chooseFuncOffset;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        if (this.isSemiVolatile()) {
            stringBuffer.append("volatile ");
        }
        if (this.isSpace()) {
            stringBuffer.append("space count=").append(this._data >> 8 & 0xFF);
            stringBuffer.append(" type=").append(this._data & 0xFF).append(" ");
        }
        if (this.isOptimizedIf()) {
            stringBuffer.append("if dist=").append(this._data);
        } else if (this.isOptimizedChoose()) {
            stringBuffer.append("choose nCases=").append(this._data);
        } else if (this.isSkip()) {
            stringBuffer.append("skip dist=").append(this._data);
        } else if (this.isSum()) {
            stringBuffer.append("sum ");
        } else if (this.isBaxcel()) {
            stringBuffer.append("assign ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(25 + this.getPtgClass());
        littleEndianOutput.writeByte(this._options);
        littleEndianOutput.writeShort(this._data);
        int[] nArray = this._jumpTable;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                littleEndianOutput.writeShort(nArray[i]);
            }
            littleEndianOutput.writeShort(this._chooseFuncOffset);
        }
    }

    public int getSize() {
        if (this._jumpTable != null) {
            return 4 + (this._jumpTable.length + 1) * 2;
        }
        return 4;
    }

    public String toFormulaString(String[] stringArray) {
        if (space.isSet(this._options)) {
            return stringArray[0];
        }
        if (optiIf.isSet(this._options)) {
            return this.toFormulaString() + "(" + stringArray[0] + ")";
        }
        if (optiSkip.isSet(this._options)) {
            return this.toFormulaString() + stringArray[0];
        }
        return this.toFormulaString() + "(" + stringArray[0] + ")";
    }

    public int getNumberOfOperands() {
        return 1;
    }

    public int getType() {
        return -1;
    }

    public String toFormulaString() {
        if (semiVolatile.isSet(this._options)) {
            return "ATTR(semiVolatile)";
        }
        if (optiIf.isSet(this._options)) {
            return "IF";
        }
        if (optiChoose.isSet(this._options)) {
            return "CHOOSE";
        }
        if (optiSkip.isSet(this._options)) {
            return "";
        }
        if (optiSum.isSet(this._options)) {
            return "SUM";
        }
        if (baxcel.isSet(this._options)) {
            return "ATTR(baxcel)";
        }
        if (space.isSet(this._options)) {
            return "";
        }
        return "UNKNOWN ATTRIBUTE";
    }

    public static final class SpaceType {
        public static final int SPACE_BEFORE = 0;
        public static final int CR_BEFORE = 1;
        public static final int SPACE_BEFORE_OPEN_PAREN = 2;
        public static final int CR_BEFORE_OPEN_PAREN = 3;
        public static final int SPACE_BEFORE_CLOSE_PAREN = 4;
        public static final int CR_BEFORE_CLOSE_PAREN = 5;
        public static final int SPACE_AFTER_EQUALITY = 6;

        private SpaceType() {
        }
    }
}

