/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.ptg.AreaI;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public abstract class AreaPtgBase
extends OperandPtg
implements AreaI {
    private int field_1_first_row;
    private int field_2_last_row;
    private int field_3_first_column;
    private int field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected final RuntimeException notImplemented() {
        return new RuntimeException("Coding Error: This method should never be called. This ptg should be converted");
    }

    protected AreaPtgBase() {
    }

    protected AreaPtgBase(AreaReference areaReference) {
        CellReference cellReference = areaReference.getFirstCell();
        CellReference cellReference2 = areaReference.getLastCell();
        this.setFirstRow(cellReference.getRow());
        this.setFirstColumn(cellReference.getCol() == -1 ? (short)0 : cellReference.getCol());
        this.setLastRow(cellReference2.getRow());
        this.setLastColumn(cellReference2.getCol() == -1 ? 255 : (int)cellReference2.getCol());
        this.setFirstColRelative(!cellReference.isColAbsolute());
        this.setLastColRelative(!cellReference2.isColAbsolute());
        this.setFirstRowRelative(!cellReference.isRowAbsolute());
        this.setLastRowRelative(!cellReference2.isRowAbsolute());
    }

    protected AreaPtgBase(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (n2 >= n) {
            this.setFirstRow(n);
            this.setLastRow(n2);
            this.setFirstRowRelative(bl);
            this.setLastRowRelative(bl2);
        } else {
            this.setFirstRow(n2);
            this.setLastRow(n);
            this.setFirstRowRelative(bl2);
            this.setLastRowRelative(bl);
        }
        if (n4 >= n3) {
            this.setFirstColumn(n3);
            this.setLastColumn(n4);
            this.setFirstColRelative(bl3);
            this.setLastColRelative(bl4);
        } else {
            this.setFirstColumn(n4);
            this.setLastColumn(n3);
            this.setFirstColRelative(bl4);
            this.setLastColRelative(bl3);
        }
    }

    protected final void readCoordinates(LittleEndianInput littleEndianInput) {
        this.field_1_first_row = littleEndianInput.readUShort();
        this.field_2_last_row = littleEndianInput.readUShort();
        this.field_3_first_column = littleEndianInput.readUShort();
        this.field_4_last_column = littleEndianInput.readUShort();
    }

    protected final void writeCoordinates(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_first_row);
        littleEndianOutput.writeShort(this.field_2_last_row);
        littleEndianOutput.writeShort(this.field_3_first_column);
        littleEndianOutput.writeShort(this.field_4_last_column);
    }

    public final int getFirstRow() {
        return this.field_1_first_row;
    }

    public final void setFirstRow(int n) {
        this.field_1_first_row = n;
    }

    public final int getLastRow() {
        return this.field_2_last_row;
    }

    public final void setLastRow(int n) {
        this.field_2_last_row = n;
    }

    public final int getFirstColumn() {
        return columnMask.getValue(this.field_3_first_column);
    }

    public final short getFirstColumnRaw() {
        return (short)this.field_3_first_column;
    }

    public final boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstRowRelative(boolean bl) {
        this.field_3_first_column = rowRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstColRelative(boolean bl) {
        this.field_3_first_column = colRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final void setFirstColumn(int n) {
        this.field_3_first_column = columnMask.setValue(this.field_3_first_column, n);
    }

    public final void setFirstColumnRaw(int n) {
        this.field_3_first_column = n;
    }

    public final int getLastColumn() {
        return columnMask.getValue(this.field_4_last_column);
    }

    public final short getLastColumnRaw() {
        return (short)this.field_4_last_column;
    }

    public final boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public final void setLastRowRelative(boolean bl) {
        this.field_4_last_column = rowRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public final void setLastColRelative(boolean bl) {
        this.field_4_last_column = colRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final void setLastColumn(int n) {
        this.field_4_last_column = columnMask.setValue(this.field_4_last_column, n);
    }

    public final void setLastColumnRaw(short s) {
        this.field_4_last_column = s;
    }

    protected final String formatReferenceAsString() {
        CellReference cellReference;
        CellReference cellReference2 = new CellReference(this.getFirstRow(), this.getFirstColumn(), !this.isFirstRowRelative(), !this.isFirstColRelative());
        if (AreaReference.isWholeColumnReference(SpreadsheetVersion.EXCEL97, cellReference2, cellReference = new CellReference(this.getLastRow(), this.getLastColumn(), !this.isLastRowRelative(), !this.isLastColRelative()))) {
            return new AreaReference(cellReference2, cellReference).formatAsString();
        }
        return cellReference2.formatAsString() + ":" + cellReference.formatAsString();
    }

    public String toFormulaString() {
        return this.formatReferenceAsString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

