/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai2.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import ai2.org.apache.poi.ss.formula.ptg.OperationPtg;
import java.util.Locale;

public abstract class AbstractFunctionPtg
extends OperationPtg {
    public static final String FUNCTION_NAME_IF = "IF";
    private static final short FUNCTION_INDEX_EXTERNAL = 255;
    private final byte returnClass;
    private final byte[] paramClass;
    private final byte _numberOfArgs;
    private final short _functionIndex;

    protected AbstractFunctionPtg(int n, int n2, byte[] byArray, int n3) {
        this._numberOfArgs = (byte)n3;
        this._functionIndex = (short)n;
        this.returnClass = (byte)n2;
        this.paramClass = byArray;
    }

    public final boolean isBaseToken() {
        return false;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName()).append(" [");
        stringBuilder.append(this.lookupName(this._functionIndex));
        stringBuilder.append(" nArgs=").append(this._numberOfArgs);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final short getFunctionIndex() {
        return this._functionIndex;
    }

    public final int getNumberOfOperands() {
        return this._numberOfArgs;
    }

    public final String getName() {
        return this.lookupName(this._functionIndex);
    }

    public final boolean isExternalFunction() {
        return this._functionIndex == 255;
    }

    public final String toFormulaString() {
        return this.getName();
    }

    public String toFormulaString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isExternalFunction()) {
            stringBuilder.append(stringArray[0]);
            AbstractFunctionPtg.appendArgs(stringBuilder, 1, stringArray);
        } else {
            stringBuilder.append(this.getName());
            AbstractFunctionPtg.appendArgs(stringBuilder, 0, stringArray);
        }
        return stringBuilder.toString();
    }

    private static void appendArgs(StringBuilder stringBuilder, int n, String[] stringArray) {
        stringBuilder.append('(');
        for (int i = n; i < stringArray.length; ++i) {
            if (i > n) {
                stringBuilder.append(',');
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append(")");
    }

    public abstract int getSize();

    public static final boolean isBuiltInFunctionName(String string) {
        short s = FunctionMetadataRegistry.lookupIndexByName(string.toUpperCase(Locale.ROOT));
        return s >= 0;
    }

    protected final String lookupName(short s) {
        if (s == 255) {
            return "#external#";
        }
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(s);
        if (functionMetadata == null) {
            throw new RuntimeException("bad function index (" + s + ")");
        }
        return functionMetadata.getName();
    }

    protected static short lookupIndex(String string) {
        short s = FunctionMetadataRegistry.lookupIndexByName(string.toUpperCase(Locale.ROOT));
        if (s < 0) {
            return 255;
        }
        return s;
    }

    public byte getDefaultOperandClass() {
        return this.returnClass;
    }

    public final byte getParameterClass(int n) {
        if (n >= this.paramClass.length) {
            return this.paramClass[this.paramClass.length - 1];
        }
        return this.paramClass[n];
    }
}

