/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;

public final class Value
extends Fixed1ArgFunction {
    private static final int MIN_DISTANCE_BETWEEN_THOUSANDS_SEPARATOR = 4;
    private static final Double ZERO = new Double(0.0);

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        ValueEval valueEval2;
        try {
            valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        String string = OperandResolver.coerceValueToString(valueEval2);
        Double d = Value.convertTextToNumber(string);
        if (d == null) {
            return ErrorEval.VALUE_INVALID;
        }
        return new NumberEval(d);
    }

    private static Double convertTextToNumber(String string) {
        double d;
        char c;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = string.length();
        block15: for (n = 0; n < n2 && !Character.isDigit(c = string.charAt(n)) && c != '.'; ++n) {
            switch (c) {
                case ' ': {
                    continue block15;
                }
                case '$': {
                    if (bl) {
                        return null;
                    }
                    bl = true;
                    continue block15;
                }
                case '+': {
                    if (bl3 || bl2) {
                        return null;
                    }
                    bl2 = true;
                    continue block15;
                }
                case '-': {
                    if (bl3 || bl2) {
                        return null;
                    }
                    bl3 = true;
                    continue block15;
                }
                default: {
                    return null;
                }
            }
        }
        if (n >= n2) {
            if (bl || bl3 || bl2) {
                return null;
            }
            return ZERO;
        }
        c = '\u0000';
        int n3 = Short.MIN_VALUE;
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n < n2) {
            char c2 = string.charAt(n);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
            } else {
                switch (c2) {
                    case ' ': {
                        String string2 = string.substring(n).trim();
                        if (string2.equals("%")) {
                            bl4 = true;
                            break;
                        }
                        if (string2.length() <= 0) break;
                        return null;
                    }
                    case '.': {
                        if (c != '\u0000') {
                            return null;
                        }
                        if (n - n3 < 4) {
                            return null;
                        }
                        c = '\u0001';
                        stringBuffer.append('.');
                        break;
                    }
                    case ',': {
                        if (c != '\u0000') {
                            return null;
                        }
                        int n4 = n - n3;
                        if (n4 < 4) {
                            return null;
                        }
                        n3 = n;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (n - n3 < 4) {
                            return null;
                        }
                        stringBuffer.append(string.substring(n));
                        n = n2;
                        break;
                    }
                    case '%': {
                        bl4 = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            ++n;
        }
        if (c == '\u0000' && n - n3 < 4) {
            return null;
        }
        try {
            d = Double.parseDouble(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        double d2 = bl3 ? -d : d;
        return bl4 ? d2 / 100.0 : d2;
    }
}

