/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.formula.functions.Var1or2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import ai2.org.apache.poi.ss.usermodel.DataFormatter;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class TextFunction
implements Function {
    protected static final DataFormatter formatter = new DataFormatter();
    protected static final String EMPTY_STRING = "";
    public static final Function CHAR = new Fixed1ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            int n3;
            try {
                n3 = TextFunction.evaluateIntArg(valueEval, n, n2);
                if (n3 < 0 || n3 >= 256) {
                    throw new EvaluationException(ErrorEval.VALUE_INVALID);
                }
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new StringEval(String.valueOf((char)n3));
        }
    };
    public static final Function LEN = new SingleArgTextFunc(){

        protected ValueEval evaluate(String string) {
            return new NumberEval(string.length());
        }
    };
    public static final Function LOWER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String string) {
            return new StringEval(string.toLowerCase(Locale.ROOT));
        }
    };
    public static final Function UPPER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String string) {
            return new StringEval(string.toUpperCase(Locale.ROOT));
        }
    };
    public static final Function PROPER = new SingleArgTextFunc(){
        final Pattern nonAlphabeticPattern = Pattern.compile("\\P{IsL}");

        protected ValueEval evaluate(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            String string2 = string.toLowerCase(Locale.ROOT);
            String string3 = string.toUpperCase(Locale.ROOT);
            for (int i = 0; i < string.length(); ++i) {
                if (bl) {
                    stringBuilder.append(string3.charAt(i));
                } else {
                    stringBuilder.append(string2.charAt(i));
                }
                bl = this.nonAlphabeticPattern.matcher(string.subSequence(i, i + 1)).matches();
            }
            return new StringEval(stringBuilder.toString());
        }
    };
    public static final Function TRIM = new SingleArgTextFunc(){

        protected ValueEval evaluate(String string) {
            return new StringEval(string.trim());
        }
    };
    public static final Function CLEAN = new SingleArgTextFunc(){

        protected ValueEval evaluate(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.isPrintable(c)) continue;
                stringBuilder.append(c);
            }
            return new StringEval(stringBuilder.toString());
        }

        private boolean isPrintable(char c) {
            char c2 = c;
            return c2 >= ' ';
        }
    };
    public static final Function MID = new Fixed3ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
            int n3;
            int n4;
            String string;
            try {
                string = TextFunction.evaluateStringArg(valueEval, n, n2);
                n4 = TextFunction.evaluateIntArg(valueEval2, n, n2);
                n3 = TextFunction.evaluateIntArg(valueEval3, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            int n5 = n4 - 1;
            if (n5 < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            if (n3 < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            int n6 = string.length();
            if (n3 < 0 || n5 > n6) {
                return new StringEval(TextFunction.EMPTY_STRING);
            }
            int n7 = Math.min(n5 + n3, n6);
            String string2 = string.substring(n5, n7);
            return new StringEval(string2);
        }
    };
    public static final Function LEFT = new LeftRight(true);
    public static final Function RIGHT = new LeftRight(false);
    public static final Function CONCATENATE = new Function(){

        public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = valueEvalArray.length;
            for (int i = 0; i < n3; ++i) {
                try {
                    stringBuilder.append(TextFunction.evaluateStringArg(valueEvalArray[i], n, n2));
                    continue;
                }
                catch (EvaluationException evaluationException) {
                    return evaluationException.getErrorEval();
                }
            }
            return new StringEval(stringBuilder.toString());
        }
    };
    public static final Function EXACT = new Fixed2ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            String string;
            String string2;
            try {
                string2 = TextFunction.evaluateStringArg(valueEval, n, n2);
                string = TextFunction.evaluateStringArg(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return BoolEval.valueOf(string2.equals(string));
        }
    };
    public static final Function TEXT = new Fixed2ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            String string;
            double d;
            try {
                d = TextFunction.evaluateDoubleArg(valueEval, n, n2);
                string = TextFunction.evaluateStringArg(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            try {
                String string2 = formatter.formatRawCellContents(d, -1, string);
                return new StringEval(string2);
            }
            catch (Exception exception) {
                return ErrorEval.VALUE_INVALID;
            }
        }
    };
    public static final Function FIND = new SearchFind(true);
    public static final Function SEARCH = new SearchFind(false);

    protected static final String evaluateStringArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToString(valueEval2);
    }

    protected static final int evaluateIntArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToInt(valueEval2);
    }

    protected static final double evaluateDoubleArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToDouble(valueEval2);
    }

    public final ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        try {
            return this.evaluateFunc(valueEvalArray, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    protected abstract ValueEval evaluateFunc(ValueEval[] var1, int var2, int var3) throws EvaluationException;

    private static final class SearchFind
    extends Var2or3ArgFunction {
        private final boolean _isCaseSensitive;

        public SearchFind(boolean bl) {
            this._isCaseSensitive = bl;
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            try {
                String string = TextFunction.evaluateStringArg(valueEval, n, n2);
                String string2 = TextFunction.evaluateStringArg(valueEval2, n, n2);
                return this.eval(string2, string, 0);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
            try {
                String string = TextFunction.evaluateStringArg(valueEval, n, n2);
                String string2 = TextFunction.evaluateStringArg(valueEval2, n, n2);
                int n3 = TextFunction.evaluateIntArg(valueEval3, n, n2) - 1;
                if (n3 < 0) {
                    return ErrorEval.VALUE_INVALID;
                }
                return this.eval(string2, string, n3);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
        }

        private ValueEval eval(String string, String string2, int n) {
            int n2 = this._isCaseSensitive ? string.indexOf(string2, n) : string.toUpperCase(Locale.ROOT).indexOf(string2.toUpperCase(Locale.ROOT), n);
            if (n2 == -1) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(n2 + 1);
        }
    }

    private static final class LeftRight
    extends Var1or2ArgFunction {
        private static final ValueEval DEFAULT_ARG1 = new NumberEval(1.0);
        private final boolean _isLeft;

        protected LeftRight(boolean bl) {
            this._isLeft = bl;
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            return this.evaluate(n, n2, valueEval, DEFAULT_ARG1);
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            int n3;
            String string;
            try {
                string = TextFunction.evaluateStringArg(valueEval, n, n2);
                n3 = TextFunction.evaluateIntArg(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            if (n3 < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            String string2 = this._isLeft ? string.substring(0, Math.min(string.length(), n3)) : string.substring(Math.max(0, string.length() - n3));
            return new StringEval(string2);
        }
    }

    private static abstract class SingleArgTextFunc
    extends Fixed1ArgFunction {
        protected SingleArgTextFunc() {
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            String string;
            try {
                string = TextFunction.evaluateStringArg(valueEval, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return this.evaluate(string);
        }

        protected abstract ValueEval evaluate(String var1);
    }
}

