/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function;

public final class Sumproduct
implements Function {
    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        int n3 = valueEvalArray.length;
        if (n3 < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval valueEval = valueEvalArray[0];
        try {
            if (valueEval instanceof NumericValueEval) {
                return Sumproduct.evaluateSingleProduct(valueEvalArray);
            }
            if (valueEval instanceof RefEval) {
                return Sumproduct.evaluateSingleProduct(valueEvalArray);
            }
            if (valueEval instanceof TwoDEval) {
                TwoDEval twoDEval = (TwoDEval)valueEval;
                if (twoDEval.isRow() && twoDEval.isColumn()) {
                    return Sumproduct.evaluateSingleProduct(valueEvalArray);
                }
                return Sumproduct.evaluateAreaSumProduct(valueEvalArray);
            }
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        throw new RuntimeException("Invalid arg type for SUMPRODUCT: (" + valueEval.getClass().getName() + ")");
    }

    private static ValueEval evaluateSingleProduct(ValueEval[] valueEvalArray) throws EvaluationException {
        int n = valueEvalArray.length;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            double d2 = Sumproduct.getScalarValue(valueEvalArray[i]);
            d *= d2;
        }
        return new NumberEval(d);
    }

    private static double getScalarValue(ValueEval valueEval) throws EvaluationException {
        ValueEval valueEval2;
        ValueEval valueEval3;
        if (valueEval instanceof RefEval) {
            valueEval3 = (RefEval)valueEval;
            if (valueEval3.getNumberOfSheets() > 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            valueEval2 = valueEval3.getInnerValueEval(valueEval3.getFirstSheetIndex());
        } else {
            valueEval2 = valueEval;
        }
        if (valueEval2 == null) {
            throw new RuntimeException("parameter may not be null");
        }
        if (valueEval2 instanceof AreaEval) {
            valueEval3 = (AreaEval)valueEval2;
            if (!valueEval3.isColumn() || !valueEval3.isRow()) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            valueEval2 = valueEval3.getRelativeValue(0, 0);
        }
        return Sumproduct.getProductTerm(valueEval2, true);
    }

    private static ValueEval evaluateAreaSumProduct(ValueEval[] valueEvalArray) throws EvaluationException {
        int n = valueEvalArray.length;
        TwoDEval[] twoDEvalArray = new TwoDEval[n];
        try {
            System.arraycopy(valueEvalArray, 0, twoDEvalArray, 0, n);
        }
        catch (ArrayStoreException arrayStoreException) {
            return ErrorEval.VALUE_INVALID;
        }
        TwoDEval twoDEval = twoDEvalArray[0];
        int n2 = twoDEval.getHeight();
        int n3 = twoDEval.getWidth();
        if (!Sumproduct.areasAllSameSize(twoDEvalArray, n2, n3)) {
            for (int i = 1; i < twoDEvalArray.length; ++i) {
                Sumproduct.throwFirstError(twoDEvalArray[i]);
            }
            return ErrorEval.VALUE_INVALID;
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d2 = 1.0;
                for (int k = 0; k < n; ++k) {
                    double d3 = Sumproduct.getProductTerm(twoDEvalArray[k].getValue(i, j), false);
                    d2 *= d3;
                }
                d += d2;
            }
        }
        return new NumberEval(d);
    }

    private static void throwFirstError(TwoDEval twoDEval) throws EvaluationException {
        int n = twoDEval.getHeight();
        int n2 = twoDEval.getWidth();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ValueEval valueEval = twoDEval.getValue(i, j);
                if (!(valueEval instanceof ErrorEval)) continue;
                throw new EvaluationException((ErrorEval)valueEval);
            }
        }
    }

    private static boolean areasAllSameSize(TwoDEval[] twoDEvalArray, int n, int n2) {
        for (int i = 0; i < twoDEvalArray.length; ++i) {
            TwoDEval twoDEval = twoDEvalArray[i];
            if (twoDEval.getHeight() != n) {
                return false;
            }
            if (twoDEval.getWidth() == n2) continue;
            return false;
        }
        return true;
    }

    private static double getProductTerm(ValueEval valueEval, boolean bl) throws EvaluationException {
        if (valueEval instanceof BlankEval || valueEval == null) {
            if (bl) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval instanceof StringEval) {
            if (bl) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return numericValueEval.getNumberValue();
        }
        throw new RuntimeException("Unexpected value eval class (" + valueEval.getClass().getName() + ")");
    }
}

