/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.CountUtils;
import ai2.org.apache.poi.ss.formula.functions.Countif;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public final class Sumif
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        AreaEval areaEval;
        try {
            areaEval = Sumif.convertRangeArg(valueEval);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return Sumif.eval(n, n2, valueEval2, areaEval, areaEval);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        AreaEval areaEval;
        AreaEval areaEval2;
        try {
            areaEval2 = Sumif.convertRangeArg(valueEval);
            areaEval = Sumif.createSumRange(valueEval3, areaEval2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return Sumif.eval(n, n2, valueEval2, areaEval2, areaEval);
    }

    private static ValueEval eval(int n, int n2, ValueEval valueEval, AreaEval areaEval, AreaEval areaEval2) {
        CountUtils.I_MatchPredicate i_MatchPredicate = Countif.createCriteriaPredicate(valueEval, n, n2);
        if (i_MatchPredicate == null) {
            return NumberEval.ZERO;
        }
        double d = Sumif.sumMatchingCells(areaEval, i_MatchPredicate, areaEval2);
        return new NumberEval(d);
    }

    private static double sumMatchingCells(AreaEval areaEval, CountUtils.I_MatchPredicate i_MatchPredicate, AreaEval areaEval2) {
        int n = areaEval.getHeight();
        int n2 = areaEval.getWidth();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                d += Sumif.accumulate(areaEval, i_MatchPredicate, areaEval2, i, j);
            }
        }
        return d;
    }

    private static double accumulate(AreaEval areaEval, CountUtils.I_MatchPredicate i_MatchPredicate, AreaEval areaEval2, int n, int n2) {
        if (!i_MatchPredicate.matches(areaEval.getRelativeValue(n, n2))) {
            return 0.0;
        }
        ValueEval valueEval = areaEval2.getRelativeValue(n, n2);
        if (valueEval instanceof NumberEval) {
            return ((NumberEval)valueEval).getNumberValue();
        }
        return 0.0;
    }

    private static AreaEval createSumRange(ValueEval valueEval, AreaEval areaEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return ((AreaEval)valueEval).offset(0, areaEval.getHeight() - 1, 0, areaEval.getWidth() - 1);
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, areaEval.getHeight() - 1, 0, areaEval.getWidth() - 1);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    private static AreaEval convertRangeArg(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return (AreaEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

