/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedException;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.AggregateFunction;
import ai2.org.apache.poi.ss.formula.functions.Count;
import ai2.org.apache.poi.ss.formula.functions.Counta;
import ai2.org.apache.poi.ss.formula.functions.Function;

public class Subtotal
implements Function {
    private static Function findFunction(int n) throws EvaluationException {
        switch (n) {
            case 1: {
                return AggregateFunction.subtotalInstance(AggregateFunction.AVERAGE);
            }
            case 2: {
                return Count.subtotalInstance();
            }
            case 3: {
                return Counta.subtotalInstance();
            }
            case 4: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MAX);
            }
            case 5: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MIN);
            }
            case 6: {
                return AggregateFunction.subtotalInstance(AggregateFunction.PRODUCT);
            }
            case 7: {
                return AggregateFunction.subtotalInstance(AggregateFunction.STDEV);
            }
            case 8: {
                throw new NotImplementedFunctionException("STDEVP");
            }
            case 9: {
                return AggregateFunction.subtotalInstance(AggregateFunction.SUM);
            }
            case 10: {
                throw new NotImplementedFunctionException("VAR");
            }
            case 11: {
                throw new NotImplementedFunctionException("VARP");
            }
        }
        if (n > 100 && n < 112) {
            throw new NotImplementedException("SUBTOTAL - with 'exclude hidden values' option");
        }
        throw EvaluationException.invalidValue();
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        Function function;
        ValueEval[] valueEvalArray2;
        int n3 = valueEvalArray.length - 1;
        if (n3 < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            valueEvalArray2 = OperandResolver.getSingleValue(valueEvalArray[0], n, n2);
            int n4 = OperandResolver.coerceValueToInt((ValueEval)valueEvalArray2);
            function = Subtotal.findFunction(n4);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        valueEvalArray2 = new ValueEval[n3];
        System.arraycopy(valueEvalArray, 1, valueEvalArray2, 0, n3);
        return function.evaluate(valueEvalArray2, n, n2);
    }
}

