/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function;

public class Rate
implements Function {
    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        double d;
        if (valueEvalArray.length < 3) {
            return ErrorEval.VALUE_INVALID;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.1;
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(valueEvalArray[0], n, n2);
            ValueEval valueEval2 = OperandResolver.getSingleValue(valueEvalArray[1], n, n2);
            ValueEval valueEval3 = OperandResolver.getSingleValue(valueEvalArray[2], n, n2);
            ValueEval valueEval4 = null;
            if (valueEvalArray.length >= 4) {
                valueEval4 = OperandResolver.getSingleValue(valueEvalArray[3], n, n2);
            }
            ValueEval valueEval5 = null;
            if (valueEvalArray.length >= 5) {
                valueEval5 = OperandResolver.getSingleValue(valueEvalArray[4], n, n2);
            }
            ValueEval valueEval6 = null;
            if (valueEvalArray.length >= 6) {
                valueEval6 = OperandResolver.getSingleValue(valueEvalArray[5], n, n2);
            }
            double d5 = OperandResolver.coerceValueToDouble(valueEval);
            double d6 = OperandResolver.coerceValueToDouble(valueEval2);
            double d7 = OperandResolver.coerceValueToDouble(valueEval3);
            if (valueEvalArray.length >= 4) {
                d2 = OperandResolver.coerceValueToDouble(valueEval4);
            }
            if (valueEvalArray.length >= 5) {
                d3 = OperandResolver.coerceValueToDouble(valueEval5);
            }
            if (valueEvalArray.length >= 6) {
                d4 = OperandResolver.coerceValueToDouble(valueEval6);
            }
            d = this.calculateRate(d5, d6, d7, d2, d3, d4);
            Rate.checkValue(d);
        }
        catch (EvaluationException evaluationException) {
            evaluationException.printStackTrace();
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private double calculateRate(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        int n = 20;
        double d8 = 1.0E-7;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = d6;
        if (Math.abs(d12) < d8) {
            d7 = d3 * (1.0 + d * d12) + d2 * (1.0 + d12 * d5) * d + d4;
        } else {
            d10 = Math.exp(d * Math.log(1.0 + d12));
            d7 = d3 * d10 + d2 * (1.0 / d12 + d5) * (d10 - 1.0) + d4;
        }
        double d13 = d3 + d2 * d + d4;
        double d14 = d3 * d10 + d2 * (1.0 / d12 + d5) * (d10 - 1.0) + d4;
        double d15 = 0.0;
        d9 = d12;
        for (d11 = 0.0; Math.abs(d13 - d14) > d8 && d11 < (double)n; d11 += 1.0) {
            d12 = (d14 * d15 - d13 * d9) / (d14 - d13);
            d15 = d9;
            d9 = d12;
            if (Math.abs(d12) < d8) {
                d7 = d3 * (1.0 + d * d12) + d2 * (1.0 + d12 * d5) * d + d4;
            } else {
                d10 = Math.exp(d * Math.log(1.0 + d12));
                d7 = d3 * d10 + d2 * (1.0 / d12 + d5) * (d10 - 1.0) + d4;
            }
            d13 = d14;
            d14 = d7;
        }
        return d12;
    }

    static final void checkValue(double d) throws EvaluationException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    }
}

