/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.LookupUtils;

public final class LinearRegressionFunction
extends Fixed2ArgFunction {
    public FUNCTION function;

    public LinearRegressionFunction(FUNCTION fUNCTION) {
        this.function = fUNCTION;
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d;
        try {
            LookupUtils.ValueVector valueVector = LinearRegressionFunction.createValueVector(valueEval);
            LookupUtils.ValueVector valueVector2 = LinearRegressionFunction.createValueVector(valueEval2);
            int n3 = valueVector2.getSize();
            if (n3 == 0 || valueVector.getSize() != n3) {
                return ErrorEval.NA;
            }
            d = this.evaluateInternal(valueVector2, valueVector, n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    private double evaluateInternal(LookupUtils.ValueVector valueVector, LookupUtils.ValueVector valueVector2, int n) throws EvaluationException {
        ErrorEval errorEval = null;
        ErrorEval errorEval2 = null;
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ValueEval valueEval = valueVector.getItem(i);
            ValueEval valueEval2 = valueVector2.getItem(i);
            if (valueEval instanceof ErrorEval && errorEval == null) {
                errorEval = (ErrorEval)valueEval;
                continue;
            }
            if (valueEval2 instanceof ErrorEval && errorEval2 == null) {
                errorEval2 = (ErrorEval)valueEval2;
                continue;
            }
            if (!(valueEval instanceof NumberEval) || !(valueEval2 instanceof NumberEval)) continue;
            bl = true;
            NumberEval numberEval = (NumberEval)valueEval;
            NumberEval numberEval2 = (NumberEval)valueEval2;
            d += numberEval.getNumberValue();
            d2 += numberEval2.getNumberValue();
        }
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            ValueEval valueEval = valueVector.getItem(i);
            ValueEval valueEval3 = valueVector2.getItem(i);
            if (valueEval instanceof ErrorEval && errorEval == null) {
                errorEval = (ErrorEval)valueEval;
                continue;
            }
            if (valueEval3 instanceof ErrorEval && errorEval2 == null) {
                errorEval2 = (ErrorEval)valueEval3;
                continue;
            }
            if (!(valueEval instanceof NumberEval) || !(valueEval3 instanceof NumberEval)) continue;
            NumberEval numberEval = (NumberEval)valueEval;
            NumberEval numberEval3 = (NumberEval)valueEval3;
            d5 += (numberEval.getNumberValue() - d3) * (numberEval.getNumberValue() - d3);
            d6 += (numberEval.getNumberValue() - d3) * (numberEval3.getNumberValue() - d4);
        }
        double d7 = d6 / d5;
        double d8 = d4 - d7 * d3;
        if (errorEval != null) {
            throw new EvaluationException(errorEval);
        }
        if (errorEval2 != null) {
            throw new EvaluationException(errorEval2);
        }
        if (!bl) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        if (this.function == FUNCTION.INTERCEPT) {
            return d8;
        }
        return d7;
    }

    private static LookupUtils.ValueVector createValueVector(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval instanceof TwoDEval) {
            return new AreaValueArray((TwoDEval)valueEval);
        }
        if (valueEval instanceof RefEval) {
            return new RefValueArray((RefEval)valueEval);
        }
        return new SingleCellValueArray(valueEval);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FUNCTION {
        INTERCEPT,
        SLOPE;

    }

    private static final class AreaValueArray
    extends ValueArray {
        private final TwoDEval _ae;
        private final int _width;

        public AreaValueArray(TwoDEval twoDEval) {
            super(twoDEval.getWidth() * twoDEval.getHeight());
            this._ae = twoDEval;
            this._width = twoDEval.getWidth();
        }

        protected ValueEval getItemInternal(int n) {
            int n2 = n / this._width;
            int n3 = n % this._width;
            return this._ae.getValue(n2, n3);
        }
    }

    private static final class RefValueArray
    extends ValueArray {
        private final RefEval _ref;
        private final int _width;

        public RefValueArray(RefEval refEval) {
            super(refEval.getNumberOfSheets());
            this._ref = refEval;
            this._width = refEval.getNumberOfSheets();
        }

        protected ValueEval getItemInternal(int n) {
            int n2 = n % this._width + this._ref.getFirstSheetIndex();
            return this._ref.getInnerValueEval(n2);
        }
    }

    private static final class SingleCellValueArray
    extends ValueArray {
        private final ValueEval _value;

        public SingleCellValueArray(ValueEval valueEval) {
            super(1);
            this._value = valueEval;
        }

        protected ValueEval getItemInternal(int n) {
            return this._value;
        }
    }

    private static abstract class ValueArray
    implements LookupUtils.ValueVector {
        private final int _size;

        protected ValueArray(int n) {
            this._size = n;
        }

        public ValueEval getItem(int n) {
            if (n < 0 || n > this._size) {
                throw new IllegalArgumentException("Specified index " + n + " is outside range (0.." + (this._size - 1) + ")");
            }
            return this.getItemInternal(n);
        }

        protected abstract ValueEval getItemInternal(int var1);

        public final int getSize() {
            return this._size;
        }
    }
}

