/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;

public final class Indirect
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Indirect();

    private Indirect() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        boolean bl;
        String string;
        if (valueEvalArray.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval valueEval = OperandResolver.getSingleValue(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
            string = OperandResolver.coerceValueToString(valueEval);
            switch (valueEvalArray.length) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = Indirect.evaluateBooleanArg(valueEvalArray[1], operationEvaluationContext);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return Indirect.evaluateIndirect(operationEvaluationContext, string, bl);
    }

    private static boolean evaluateBooleanArg(ValueEval valueEval, OperationEvaluationContext operationEvaluationContext) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
        if (valueEval2 == BlankEval.instance || valueEval2 == MissingArgEval.instance) {
            return false;
        }
        return OperandResolver.coerceValueToBoolean(valueEval2, false);
    }

    private static ValueEval evaluateIndirect(OperationEvaluationContext operationEvaluationContext, String string, boolean bl) {
        String string2;
        Object object;
        String string3;
        String string4;
        String string5;
        int n = string.lastIndexOf(33);
        if (n < 0) {
            string5 = null;
            string4 = null;
            string3 = string;
        } else {
            object = Indirect.parseWorkbookAndSheetName(string.subSequence(0, n));
            if (object == null) {
                return ErrorEval.REF_INVALID;
            }
            string5 = object[0];
            string4 = object[1];
            string3 = string.substring(n + 1);
        }
        int n2 = string3.indexOf(58);
        if (n2 < 0) {
            object = string3.trim();
            string2 = null;
        } else {
            object = string3.substring(0, n2).trim();
            string2 = string3.substring(n2 + 1).trim();
        }
        return operationEvaluationContext.getDynamicReference(string5, string4, (String)object, string2, bl);
    }

    private static String[] parseWorkbookAndSheetName(CharSequence charSequence) {
        int n = charSequence.length() - 1;
        if (n < 0) {
            return null;
        }
        if (Indirect.canTrim(charSequence)) {
            return null;
        }
        char c = charSequence.charAt(0);
        if (Character.isWhitespace(c)) {
            return null;
        }
        if (c == '\'') {
            int n2;
            String string;
            if (charSequence.charAt(n) != '\'') {
                return null;
            }
            c = charSequence.charAt(1);
            if (Character.isWhitespace(c)) {
                return null;
            }
            if (c == '[') {
                int n3 = charSequence.toString().lastIndexOf(93);
                if (n3 < 0) {
                    return null;
                }
                string = Indirect.unescapeString(charSequence.subSequence(2, n3));
                if (string == null || Indirect.canTrim(string)) {
                    return null;
                }
                n2 = n3 + 1;
            } else {
                string = null;
                n2 = 1;
            }
            String string2 = Indirect.unescapeString(charSequence.subSequence(n2, n));
            if (string2 == null) {
                return null;
            }
            return new String[]{string, string2};
        }
        if (c == '[') {
            int n4 = charSequence.toString().lastIndexOf(93);
            if (n4 < 0) {
                return null;
            }
            CharSequence charSequence2 = charSequence.subSequence(1, n4);
            if (Indirect.canTrim(charSequence2)) {
                return null;
            }
            CharSequence charSequence3 = charSequence.subSequence(n4 + 1, charSequence.length());
            if (Indirect.canTrim(charSequence3)) {
                return null;
            }
            return new String[]{charSequence2.toString(), charSequence3.toString()};
        }
        return new String[]{null, charSequence.toString()};
    }

    private static String unescapeString(CharSequence charSequence) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\'') {
                if (++i >= n) {
                    return null;
                }
                c = charSequence.charAt(i);
                if (c != '\'') {
                    return null;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean canTrim(CharSequence charSequence) {
        int n = charSequence.length() - 1;
        if (n < 0) {
            return false;
        }
        if (Character.isWhitespace(charSequence.charAt(0))) {
            return true;
        }
        return Character.isWhitespace(charSequence.charAt(n));
    }
}

