/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function2Arg;
import ai2.org.apache.poi.ss.formula.functions.Function3Arg;
import ai2.org.apache.poi.ss.formula.functions.Function4Arg;

public final class Index
implements Function2Arg,
Function3Arg,
Function4Arg {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        TwoDEval twoDEval = Index.convertFirstArg(valueEval);
        int n3 = 0;
        try {
            int n4 = Index.resolveIndexArg(valueEval2, n, n2);
            if (!twoDEval.isColumn()) {
                if (!twoDEval.isRow()) {
                    return ErrorEval.REF_INVALID;
                }
                n3 = n4;
                n4 = 0;
            }
            return Index.getValueFromArea(twoDEval, n4, n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        TwoDEval twoDEval = Index.convertFirstArg(valueEval);
        try {
            int n3 = Index.resolveIndexArg(valueEval3, n, n2);
            int n4 = Index.resolveIndexArg(valueEval2, n, n2);
            return Index.getValueFromArea(twoDEval, n4, n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3, ValueEval valueEval4) {
        throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
    }

    private static TwoDEval convertFirstArg(ValueEval valueEval) {
        ValueEval valueEval2 = valueEval;
        if (valueEval2 instanceof RefEval) {
            return ((RefEval)valueEval2).offset(0, 0, 0, 0);
        }
        if (valueEval2 instanceof TwoDEval) {
            return (TwoDEval)valueEval2;
        }
        throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + valueEval2.getClass().getName() + ")");
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        switch (valueEvalArray.length) {
            case 2: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1]);
            }
            case 3: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2]);
            }
            case 4: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2], valueEvalArray[3]);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    private static ValueEval getValueFromArea(TwoDEval twoDEval, int n, int n2) throws EvaluationException {
        assert (n >= 0);
        assert (n2 >= 0);
        TwoDEval twoDEval2 = twoDEval;
        if (n != 0) {
            if (n > twoDEval.getHeight()) {
                throw new EvaluationException(ErrorEval.REF_INVALID);
            }
            twoDEval2 = twoDEval2.getRow(n - 1);
        }
        if (n2 != 0) {
            if (n2 > twoDEval.getWidth()) {
                throw new EvaluationException(ErrorEval.REF_INVALID);
            }
            twoDEval2 = twoDEval2.getColumn(n2 - 1);
        }
        return twoDEval2;
    }

    private static int resolveIndexArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        if (valueEval2 == MissingArgEval.instance) {
            return 0;
        }
        if (valueEval2 == BlankEval.instance) {
            return 0;
        }
        int n3 = OperandResolver.coerceValueToInt(valueEval2);
        if (n3 < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return n3;
    }
}

