/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function1Arg;
import ai2.org.apache.poi.ss.formula.functions.Function2Arg;
import ai2.org.apache.poi.ss.formula.functions.Function3Arg;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public final class Fixed
implements Function1Arg,
Function2Arg,
Function3Arg {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        return this.fixed(valueEval, valueEval2, valueEval3, n, n2);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        return this.fixed(valueEval, valueEval2, BoolEval.FALSE, n, n2);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        return this.fixed(valueEval, new NumberEval(2.0), BoolEval.FALSE, n, n2);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        switch (valueEvalArray.length) {
            case 1: {
                return this.fixed(valueEvalArray[0], new NumberEval(2.0), BoolEval.FALSE, n, n2);
            }
            case 2: {
                return this.fixed(valueEvalArray[0], valueEvalArray[1], BoolEval.FALSE, n, n2);
            }
            case 3: {
                return this.fixed(valueEvalArray[0], valueEvalArray[1], valueEvalArray[2], n, n2);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    private ValueEval fixed(ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3, int n, int n2) {
        try {
            ValueEval valueEval4 = OperandResolver.getSingleValue(valueEval, n, n2);
            BigDecimal bigDecimal = new BigDecimal(OperandResolver.coerceValueToDouble(valueEval4));
            ValueEval valueEval5 = OperandResolver.getSingleValue(valueEval2, n, n2);
            int n3 = OperandResolver.coerceValueToInt(valueEval5);
            ValueEval valueEval6 = OperandResolver.getSingleValue(valueEval3, n, n2);
            Boolean bl = OperandResolver.coerceValueToBoolean(valueEval6, false);
            bigDecimal = bigDecimal.setScale(n3, RoundingMode.HALF_UP);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            decimalFormat.setGroupingUsed(bl == false);
            decimalFormat.setMinimumFractionDigits(n3 >= 0 ? n3 : 0);
            decimalFormat.setMaximumFractionDigits(n3 >= 0 ? n3 : 0);
            String string = decimalFormat.format(bigDecimal.doubleValue());
            return new StringEval(string);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

