/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.functions.NumericFunction;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;
import java.util.Date;

public class EOMonth
implements FreeRefFunction {
    public static final FreeRefFunction instance = new EOMonth();

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d = NumericFunction.singleOperandEvaluate(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
            int n = (int)NumericFunction.singleOperandEvaluate(valueEvalArray[1], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
            if (d >= 0.0 && d < 1.0) {
                d = 1.0;
            }
            Date date = DateUtil.getJavaDate(d, false);
            Calendar calendar = LocaleUtil.getLocaleCalendar();
            calendar.setTime(date);
            calendar.clear(10);
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
            calendar.add(2, n + 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
            return new NumberEval(DateUtil.getExcelDate(calendar.getTime()));
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

