/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import java.math.BigDecimal;

public final class Delta
extends Fixed2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Delta();
    private static final NumberEval ONE = new NumberEval(1.0);
    private static final NumberEval ZERO = new NumberEval(0.0);

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        ValueEval valueEval3;
        ValueEval valueEval4;
        try {
            valueEval4 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        String string = OperandResolver.coerceValueToString(valueEval4);
        Double d = OperandResolver.parseDouble(string);
        if (d == null) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            valueEval3 = OperandResolver.getSingleValue(valueEval2, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        String string2 = OperandResolver.coerceValueToString(valueEval3);
        Double d2 = OperandResolver.parseDouble(string2);
        if (d2 == null) {
            return ErrorEval.VALUE_INVALID;
        }
        int n3 = new BigDecimal(d).compareTo(new BigDecimal(d2));
        return n3 == 0 ? ONE : ZERO;
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length == 2) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

