/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.functions.Var1or2ArgFunction;
import java.util.Locale;

public final class Dec2Hex
extends Var1or2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Dec2Hex();
    private static final long MIN_VALUE = Long.parseLong("-549755813888");
    private static final long MAX_VALUE = Long.parseLong("549755813887");
    private static final int DEFAULT_PLACES_VALUE = 10;

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        Object object;
        ValueEval valueEval3;
        try {
            valueEval3 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        String string = OperandResolver.coerceValueToString(valueEval3);
        Double d = OperandResolver.parseDouble(string);
        if (d == null) {
            return ErrorEval.VALUE_INVALID;
        }
        if (d.longValue() < MIN_VALUE || d.longValue() > MAX_VALUE) {
            return ErrorEval.NUM_ERROR;
        }
        int n3 = 0;
        if (d < 0.0) {
            n3 = 10;
        } else if (valueEval2 != null) {
            try {
                object = OperandResolver.getSingleValue(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            String string2 = OperandResolver.coerceValueToString((ValueEval)object);
            Double d2 = OperandResolver.parseDouble(string2);
            if (d2 == null) {
                return ErrorEval.VALUE_INVALID;
            }
            n3 = d2.intValue();
            if (n3 < 0) {
                return ErrorEval.NUM_ERROR;
            }
        }
        object = n3 != 0 ? String.format(Locale.ROOT, "%0" + n3 + "X", d.intValue()) : Long.toHexString(d.longValue());
        if (d < 0.0) {
            object = "FF" + ((String)object).substring(2);
        }
        return new StringEval(((String)object).toUpperCase(Locale.ROOT));
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        return this.evaluate(n, n2, valueEval, null);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length == 1) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0]);
        }
        if (valueEvalArray.length == 2) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

