/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.NumericFunction;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;

public class Days360
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            d = Days360.evaluate(d2, d3, false);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            ValueEval valueEval4 = OperandResolver.getSingleValue(valueEval3, n, n2);
            Boolean bl = OperandResolver.coerceValueToBoolean(valueEval4, false);
            d = Days360.evaluate(d2, d3, bl == null ? false : bl);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static double evaluate(double d, double d2, boolean bl) {
        Calendar calendar = Days360.getDate(d);
        Calendar calendar2 = Days360.getDate(d2);
        int[] nArray = Days360.getStartingDate(calendar, bl);
        int[] nArray2 = Days360.getEndingDate(calendar2, calendar, bl);
        return nArray2[0] * 360 + nArray2[1] * 30 + nArray2[2] - (nArray[0] * 360 + nArray[1] * 30 + nArray[2]);
    }

    private static Calendar getDate(double d) {
        Calendar calendar = LocaleUtil.getLocaleCalendar();
        calendar.setTime(DateUtil.getJavaDate(d, false));
        return calendar;
    }

    private static int[] getStartingDate(Calendar calendar, boolean bl) {
        Calendar calendar2 = calendar;
        int n = calendar2.get(1);
        int n2 = calendar2.get(2);
        int n3 = Math.min(30, calendar2.get(5));
        if (!bl && Days360.isLastDayOfMonth(calendar2)) {
            n3 = 30;
        }
        return new int[]{n, n2, n3};
    }

    private static int[] getEndingDate(Calendar calendar, Calendar calendar2, boolean bl) {
        Calendar calendar3 = calendar;
        int n = calendar3.get(1);
        int n2 = calendar3.get(2);
        int n3 = Math.min(30, calendar3.get(5));
        if (!bl && calendar.get(5) == 31) {
            if (calendar2.get(5) < 30) {
                calendar3.set(5, 1);
                calendar3.add(2, 1);
                n = calendar3.get(1);
                n2 = calendar3.get(2);
                n3 = 1;
            } else {
                n3 = 30;
            }
        }
        return new int[]{n, n2, n3};
    }

    private static boolean isLastDayOfMonth(Calendar calendar) {
        int n;
        int n2 = calendar.get(5);
        return n2 == (n = calendar.getActualMaximum(5));
    }
}

