/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.formula.functions.NumericFunction;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;

public final class DateFunc
extends Fixed3ArgFunction {
    public static final Function instance = new DateFunc();

    private DateFunc() {
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            double d4 = NumericFunction.singleOperandEvaluate(valueEval3, n, n2);
            d = DateFunc.evaluate(DateFunc.getYear(d2), (int)(d3 - 1.0), (int)d4);
            NumericFunction.checkValue(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static double evaluate(int n, int n2, int n3) throws EvaluationException {
        if (n < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        while (n2 < 0) {
            --n;
            n2 += 12;
        }
        if (n == 1900 && n2 == 1 && n3 == 29) {
            return 60.0;
        }
        int n4 = n3;
        if (n == 1900 && (n2 == 0 && n4 >= 60 || n2 == 1 && n4 >= 30)) {
            --n4;
        }
        Calendar calendar = LocaleUtil.getLocaleCalendar(n, n2, n4);
        if (n3 < 0 && calendar.get(1) == 1900 && n2 > 1 && calendar.get(2) < 2) {
            calendar.add(5, 1);
        }
        boolean bl = false;
        return DateUtil.getExcelDate(calendar.getTime(), bl);
    }

    private static int getYear(double d) {
        int n = (int)d;
        if (n < 0) {
            return -1;
        }
        return n < 1900 ? 1900 + n : n;
    }
}

