/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedException;
import ai2.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringValueEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.DGet;
import ai2.org.apache.poi.ss.formula.functions.DMin;
import ai2.org.apache.poi.ss.formula.functions.Function3Arg;
import ai2.org.apache.poi.ss.formula.functions.IDStarAlgorithm;
import ai2.org.apache.poi.ss.util.NumberComparer;

public final class DStarRunner
implements Function3Arg {
    private final DStarAlgorithmEnum algoType;

    public DStarRunner(DStarAlgorithmEnum dStarAlgorithmEnum) {
        this.algoType = dStarAlgorithmEnum;
    }

    public final ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        if (valueEvalArray.length == 3) {
            return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2]);
        }
        return ErrorEval.VALUE_INVALID;
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        int n3;
        if (!(valueEval instanceof TwoDEval) || !(valueEval3 instanceof TwoDEval)) {
            return ErrorEval.VALUE_INVALID;
        }
        TwoDEval twoDEval = (TwoDEval)valueEval;
        TwoDEval twoDEval2 = (TwoDEval)valueEval3;
        try {
            n3 = DStarRunner.getColumnForName(valueEval2, twoDEval);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 == -1) {
            return ErrorEval.VALUE_INVALID;
        }
        IDStarAlgorithm iDStarAlgorithm = null;
        switch (this.algoType) {
            case DGET: {
                iDStarAlgorithm = new DGet();
                break;
            }
            case DMIN: {
                iDStarAlgorithm = new DMin();
            }
        }
        for (int i = 1; i < twoDEval.getHeight(); ++i) {
            boolean bl = true;
            try {
                bl = DStarRunner.fullfillsConditions(twoDEval, i, twoDEval2);
            }
            catch (EvaluationException evaluationException) {
                return ErrorEval.VALUE_INVALID;
            }
            if (!bl) continue;
            try {
                ValueEval valueEval4 = DStarRunner.solveReference(twoDEval.getValue(i, n3));
                boolean bl2 = iDStarAlgorithm.processMatch(valueEval4);
                if (bl2) continue;
                break;
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
        }
        return iDStarAlgorithm.getResult();
    }

    private static ValueEval solveReference(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            if (refEval.getNumberOfSheets() > 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return DStarRunner.solveReference(refEval.getInnerValueEval(refEval.getFirstSheetIndex()));
        }
        return valueEval;
    }

    private static int getColumnForTag(ValueEval valueEval, TwoDEval twoDEval) throws EvaluationException {
        int n = -1;
        if (valueEval instanceof NumericValueEval) {
            double d = ((NumericValueEval)valueEval).getNumberValue();
            if (d - (double)(n = (int)d) != 0.0) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            --n;
        } else {
            n = DStarRunner.getColumnForName(valueEval, twoDEval);
        }
        return n;
    }

    private static int getColumnForName(ValueEval valueEval, TwoDEval twoDEval) throws EvaluationException {
        String string = DStarRunner.getStringFromValueEval(valueEval);
        return DStarRunner.getColumnForString(twoDEval, string);
    }

    private static int getColumnForString(TwoDEval twoDEval, String string) throws EvaluationException {
        int n = -1;
        for (int i = 0; i < twoDEval.getWidth(); ++i) {
            ValueEval valueEval = twoDEval.getValue(0, i);
            String string2 = DStarRunner.getStringFromValueEval(valueEval);
            if (!string.equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    private static boolean fullfillsConditions(TwoDEval twoDEval, int n, TwoDEval twoDEval2) throws EvaluationException {
        for (int i = 1; i < twoDEval2.getHeight(); ++i) {
            boolean bl = true;
            for (int j = 0; j < twoDEval2.getWidth(); ++j) {
                boolean bl2 = true;
                ValueEval valueEval = null;
                try {
                    valueEval = DStarRunner.solveReference(twoDEval2.getValue(i, j));
                }
                catch (RuntimeException runtimeException) {
                    bl2 = false;
                }
                if (valueEval instanceof BlankEval) continue;
                ValueEval valueEval2 = DStarRunner.solveReference(twoDEval2.getValue(0, j));
                if (!((valueEval2 = DStarRunner.solveReference(valueEval2)) instanceof StringValueEval)) {
                    bl2 = false;
                } else if (DStarRunner.getColumnForName(valueEval2, twoDEval) == -1) {
                    bl2 = false;
                }
                if (bl2) {
                    String string;
                    ValueEval valueEval3 = twoDEval.getValue(n, DStarRunner.getColumnForName(valueEval2, twoDEval));
                    if (DStarRunner.testNormalCondition(valueEval3, string = DStarRunner.getStringFromValueEval(valueEval))) continue;
                    bl = false;
                    break;
                }
                throw new NotImplementedException("D* function with formula conditions");
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private static boolean testNormalCondition(ValueEval valueEval, String string) throws EvaluationException {
        if (string.startsWith("<")) {
            String string2 = string.substring(1);
            if (string2.startsWith("=")) {
                string2 = string2.substring(1);
                return DStarRunner.testNumericCondition(valueEval, operator.smallerEqualThan, string2);
            }
            return DStarRunner.testNumericCondition(valueEval, operator.smallerThan, string2);
        }
        if (string.startsWith(">")) {
            String string3 = string.substring(1);
            if (string3.startsWith("=")) {
                string3 = string3.substring(1);
                return DStarRunner.testNumericCondition(valueEval, operator.largerEqualThan, string3);
            }
            return DStarRunner.testNumericCondition(valueEval, operator.largerThan, string3);
        }
        if (string.startsWith("=")) {
            String string4 = string.substring(1);
            boolean bl = false;
            try {
                Integer.parseInt(string4);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double.parseDouble(string4);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException2) {
                    bl = false;
                }
            }
            if (bl) {
                return DStarRunner.testNumericCondition(valueEval, operator.equal, string4);
            }
            String string5 = DStarRunner.getStringFromValueEval(valueEval);
            return string4.equals(string5);
        }
        String string6 = DStarRunner.getStringFromValueEval(valueEval);
        return string6.startsWith(string);
    }

    private static boolean testNumericCondition(ValueEval valueEval, operator operator2, String string) throws EvaluationException {
        int n;
        if (!(valueEval instanceof NumericValueEval)) {
            return false;
        }
        double d = ((NumericValueEval)valueEval).getNumberValue();
        double d2 = 0.0;
        try {
            n = Integer.parseInt(string);
            d2 = n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
        }
        n = NumberComparer.compare(d, d2);
        switch (operator2) {
            case largerThan: {
                return n > 0;
            }
            case largerEqualThan: {
                return n >= 0;
            }
            case smallerThan: {
                return n < 0;
            }
            case smallerEqualThan: {
                return n <= 0;
            }
            case equal: {
                return n == 0;
            }
        }
        return false;
    }

    private static String getStringFromValueEval(ValueEval valueEval) throws EvaluationException {
        if ((valueEval = DStarRunner.solveReference(valueEval)) instanceof BlankEval) {
            return "";
        }
        if (!(valueEval instanceof StringValueEval)) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ((StringValueEval)valueEval).getStringValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum operator {
        largerThan,
        largerEqualThan,
        smallerThan,
        smallerEqualThan,
        equal;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DStarAlgorithmEnum {
        DGET,
        DMIN;

    }
}

