/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.ThreeDEval;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.CountUtils;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import java.util.regex.Pattern;

public final class Countif
extends Fixed2ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        CountUtils.I_MatchPredicate i_MatchPredicate = Countif.createCriteriaPredicate(valueEval2, n, n2);
        if (i_MatchPredicate == null) {
            return NumberEval.ZERO;
        }
        double d = this.countMatchingCellsInArea(valueEval, i_MatchPredicate);
        return new NumberEval(d);
    }

    private double countMatchingCellsInArea(ValueEval valueEval, CountUtils.I_MatchPredicate i_MatchPredicate) {
        if (valueEval instanceof RefEval) {
            return CountUtils.countMatchingCellsInRef((RefEval)valueEval, i_MatchPredicate);
        }
        if (valueEval instanceof ThreeDEval) {
            return CountUtils.countMatchingCellsInArea((ThreeDEval)valueEval, i_MatchPredicate);
        }
        throw new IllegalArgumentException("Bad range arg type (" + valueEval.getClass().getName() + ")");
    }

    static CountUtils.I_MatchPredicate createCriteriaPredicate(ValueEval valueEval, int n, int n2) {
        ValueEval valueEval2 = Countif.evaluateCriteriaArg(valueEval, n, n2);
        if (valueEval2 instanceof NumberEval) {
            return new NumberMatcher(((NumberEval)valueEval2).getNumberValue(), CmpOp.OP_NONE);
        }
        if (valueEval2 instanceof BoolEval) {
            return new BooleanMatcher(((BoolEval)valueEval2).getBooleanValue(), CmpOp.OP_NONE);
        }
        if (valueEval2 instanceof StringEval) {
            return Countif.createGeneralMatchPredicate((StringEval)valueEval2);
        }
        if (valueEval2 instanceof ErrorEval) {
            return new ErrorMatcher(((ErrorEval)valueEval2).getErrorCode(), CmpOp.OP_NONE);
        }
        if (valueEval2 == BlankEval.instance) {
            return null;
        }
        throw new RuntimeException("Unexpected type for criteria (" + valueEval2.getClass().getName() + ")");
    }

    private static ValueEval evaluateCriteriaArg(ValueEval valueEval, int n, int n2) {
        try {
            return OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static CountUtils.I_MatchPredicate createGeneralMatchPredicate(StringEval stringEval) {
        String string = stringEval.getStringValue();
        CmpOp cmpOp = CmpOp.getOperator(string);
        Boolean bl = Countif.parseBoolean(string = string.substring(cmpOp.getLength()));
        if (bl != null) {
            return new BooleanMatcher(bl, cmpOp);
        }
        Double d = OperandResolver.parseDouble(string);
        if (d != null) {
            return new NumberMatcher(d, cmpOp);
        }
        ErrorEval errorEval = Countif.parseError(string);
        if (errorEval != null) {
            return new ErrorMatcher(errorEval.getErrorCode(), cmpOp);
        }
        return new StringMatcher(string, cmpOp);
    }

    private static ErrorEval parseError(String string) {
        if (string.length() < 4 || string.charAt(0) != '#') {
            return null;
        }
        if (string.equals("#NULL!")) {
            return ErrorEval.NULL_INTERSECTION;
        }
        if (string.equals("#DIV/0!")) {
            return ErrorEval.DIV_ZERO;
        }
        if (string.equals("#VALUE!")) {
            return ErrorEval.VALUE_INVALID;
        }
        if (string.equals("#REF!")) {
            return ErrorEval.REF_INVALID;
        }
        if (string.equals("#NAME?")) {
            return ErrorEval.NAME_INVALID;
        }
        if (string.equals("#NUM!")) {
            return ErrorEval.NUM_ERROR;
        }
        if (string.equals("#N/A")) {
            return ErrorEval.NA;
        }
        return null;
    }

    static Boolean parseBoolean(String string) {
        if (string.length() < 1) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'T': 
            case 't': {
                if (!"TRUE".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 'F': 
            case 'f': {
                if (!"FALSE".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static final class StringMatcher
    extends MatcherBase {
        private final String _value;
        private final Pattern _pattern;

        public StringMatcher(String string, CmpOp cmpOp) {
            super(cmpOp);
            this._value = string;
            switch (cmpOp.getCode()) {
                case 0: 
                case 1: 
                case 2: {
                    this._pattern = StringMatcher.getWildCardPattern(string);
                    break;
                }
                default: {
                    this._pattern = null;
                }
            }
        }

        protected String getValueText() {
            if (this._pattern == null) {
                return this._value;
            }
            return this._pattern.pattern();
        }

        public boolean matches(ValueEval valueEval) {
            if (valueEval instanceof BlankEval) {
                switch (this.getCode()) {
                    case 0: 
                    case 1: {
                        return this._value.length() == 0;
                    }
                    case 2: {
                        return this._value.length() != 0;
                    }
                }
                return false;
            }
            if (!(valueEval instanceof StringEval)) {
                return false;
            }
            String string = ((StringEval)valueEval).getStringValue();
            if (string.length() < 1 && this._value.length() < 1) {
                switch (this.getCode()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
            if (this._pattern != null) {
                return this.evaluate(this._pattern.matcher(string).matches());
            }
            return this.evaluate(string.compareToIgnoreCase(this._value));
        }

        public static Pattern getWildCardPattern(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            boolean bl = false;
            block9: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '?': {
                        bl = true;
                        stringBuffer.append('.');
                        continue block9;
                    }
                    case '*': {
                        bl = true;
                        stringBuffer.append(".*");
                        continue block9;
                    }
                    case '~': {
                        if (i + 1 < n) {
                            c = string.charAt(i + 1);
                            switch (c) {
                                case '*': 
                                case '?': {
                                    bl = true;
                                    stringBuffer.append('[').append(c).append(']');
                                    ++i;
                                    continue block9;
                                }
                            }
                        }
                        stringBuffer.append('~');
                        continue block9;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': {
                        stringBuffer.append("\\").append(c);
                        continue block9;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            if (bl) {
                return Pattern.compile(stringBuffer.toString(), 2);
            }
            return null;
        }
    }

    public static final class ErrorMatcher
    extends MatcherBase {
        private final int _value;

        public ErrorMatcher(int n, CmpOp cmpOp) {
            super(cmpOp);
            this._value = n;
        }

        protected String getValueText() {
            return FormulaError.forInt(this._value).getString();
        }

        public boolean matches(ValueEval valueEval) {
            if (valueEval instanceof ErrorEval) {
                int n = ((ErrorEval)valueEval).getErrorCode();
                return this.evaluate(n - this._value);
            }
            return false;
        }

        public int getValue() {
            return this._value;
        }
    }

    private static final class BooleanMatcher
    extends MatcherBase {
        private final int _value;

        public BooleanMatcher(boolean bl, CmpOp cmpOp) {
            super(cmpOp);
            this._value = BooleanMatcher.boolToInt(bl);
        }

        protected String getValueText() {
            return this._value == 1 ? "TRUE" : "FALSE";
        }

        private static int boolToInt(boolean bl) {
            return bl ? 1 : 0;
        }

        public boolean matches(ValueEval valueEval) {
            if (valueEval instanceof StringEval) {
                return false;
            }
            if (!(valueEval instanceof BoolEval)) {
                if (valueEval instanceof BlankEval) {
                    switch (this.getCode()) {
                        case 2: {
                            return true;
                        }
                    }
                    return false;
                }
                if (valueEval instanceof NumberEval) {
                    switch (this.getCode()) {
                        case 2: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            BoolEval boolEval = (BoolEval)valueEval;
            int n = BooleanMatcher.boolToInt(boolEval.getBooleanValue());
            return this.evaluate(n - this._value);
        }
    }

    private static final class NumberMatcher
    extends MatcherBase {
        private final double _value;

        public NumberMatcher(double d, CmpOp cmpOp) {
            super(cmpOp);
            this._value = d;
        }

        protected String getValueText() {
            return String.valueOf(this._value);
        }

        public boolean matches(ValueEval valueEval) {
            if (valueEval instanceof StringEval) {
                switch (this.getCode()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                StringEval stringEval = (StringEval)valueEval;
                Double d = OperandResolver.parseDouble(stringEval.getStringValue());
                if (d == null) {
                    return false;
                }
                return this._value == d;
            }
            if (!(valueEval instanceof NumberEval)) {
                if (valueEval instanceof BlankEval) {
                    switch (this.getCode()) {
                        case 2: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            NumberEval numberEval = (NumberEval)valueEval;
            double d = numberEval.getNumberValue();
            return this.evaluate(Double.compare(d, this._value));
        }
    }

    private static abstract class MatcherBase
    implements CountUtils.I_MatchPredicate {
        private final CmpOp _operator;

        MatcherBase(CmpOp cmpOp) {
            this._operator = cmpOp;
        }

        protected final int getCode() {
            return this._operator.getCode();
        }

        protected final boolean evaluate(int n) {
            return this._operator.evaluate(n);
        }

        protected final boolean evaluate(boolean bl) {
            return this._operator.evaluate(bl);
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this._operator.getRepresentation());
            stringBuffer.append(this.getValueText());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected abstract String getValueText();
    }

    private static final class CmpOp {
        public static final int NONE = 0;
        public static final int EQ = 1;
        public static final int NE = 2;
        public static final int LE = 3;
        public static final int LT = 4;
        public static final int GT = 5;
        public static final int GE = 6;
        public static final CmpOp OP_NONE = CmpOp.op("", 0);
        public static final CmpOp OP_EQ = CmpOp.op("=", 1);
        public static final CmpOp OP_NE = CmpOp.op("<>", 2);
        public static final CmpOp OP_LE = CmpOp.op("<=", 3);
        public static final CmpOp OP_LT = CmpOp.op("<", 4);
        public static final CmpOp OP_GT = CmpOp.op(">", 5);
        public static final CmpOp OP_GE = CmpOp.op(">=", 6);
        private final String _representation;
        private final int _code;

        private static CmpOp op(String string, int n) {
            return new CmpOp(string, n);
        }

        private CmpOp(String string, int n) {
            this._representation = string;
            this._code = n;
        }

        public int getLength() {
            return this._representation.length();
        }

        public int getCode() {
            return this._code;
        }

        public static CmpOp getOperator(String string) {
            int n = string.length();
            if (n < 1) {
                return OP_NONE;
            }
            char c = string.charAt(0);
            switch (c) {
                case '=': {
                    return OP_EQ;
                }
                case '>': {
                    if (n > 1) {
                        switch (string.charAt(1)) {
                            case '=': {
                                return OP_GE;
                            }
                        }
                    }
                    return OP_GT;
                }
                case '<': {
                    if (n > 1) {
                        switch (string.charAt(1)) {
                            case '=': {
                                return OP_LE;
                            }
                            case '>': {
                                return OP_NE;
                            }
                        }
                    }
                    return OP_LT;
                }
            }
            return OP_NONE;
        }

        public boolean evaluate(boolean bl) {
            switch (this._code) {
                case 0: 
                case 1: {
                    return bl;
                }
                case 2: {
                    return !bl;
                }
            }
            throw new RuntimeException("Cannot call boolean evaluate on non-equality operator '" + this._representation + "'");
        }

        public boolean evaluate(int n) {
            switch (this._code) {
                case 0: 
                case 1: {
                    return n == 0;
                }
                case 2: {
                    return n != 0;
                }
                case 4: {
                    return n < 0;
                }
                case 3: {
                    return n <= 0;
                }
                case 5: {
                    return n > 0;
                }
                case 6: {
                    return n >= 0;
                }
            }
            throw new RuntimeException("Cannot call boolean evaluate on non-equality operator '" + this._representation + "'");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" [").append(this._representation).append("]");
            return stringBuffer.toString();
        }

        public String getRepresentation() {
            return this._representation;
        }
    }
}

