/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import java.util.Locale;

public class Complex
extends Var2or3ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Complex();
    public static final String DEFAULT_SUFFIX = "i";
    public static final String SUPPORTED_SUFFIX = "j";

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        return this.evaluate(n, n2, valueEval, valueEval2, new StringEval(DEFAULT_SUFFIX));
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        ValueEval valueEval4;
        ValueEval valueEval5;
        try {
            valueEval5 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        double d = 0.0;
        try {
            d = OperandResolver.coerceValueToDouble(valueEval5);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            valueEval4 = OperandResolver.getSingleValue(valueEval2, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        double d2 = 0.0;
        try {
            d2 = OperandResolver.coerceValueToDouble(valueEval4);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        String string = OperandResolver.coerceValueToString(valueEval3);
        if (string.length() == 0) {
            string = DEFAULT_SUFFIX;
        }
        if (string.equals(DEFAULT_SUFFIX.toUpperCase(Locale.ROOT)) || string.equals(SUPPORTED_SUFFIX.toUpperCase(Locale.ROOT))) {
            return ErrorEval.VALUE_INVALID;
        }
        if (!string.equals(DEFAULT_SUFFIX) && !string.equals(SUPPORTED_SUFFIX)) {
            return ErrorEval.VALUE_INVALID;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (d != 0.0) {
            if (this.isDoubleAnInt(d)) {
                stringBuffer.append((int)d);
            } else {
                stringBuffer.append(d);
            }
        }
        if (d2 != 0.0) {
            if (stringBuffer.length() != 0 && d2 > 0.0) {
                stringBuffer.append("+");
            }
            if (d2 != 1.0 && d2 != -1.0) {
                if (this.isDoubleAnInt(d2)) {
                    stringBuffer.append((int)d2);
                } else {
                    stringBuffer.append(d2);
                }
            }
            stringBuffer.append(string);
        }
        return new StringEval(stringBuffer.toString());
    }

    private boolean isDoubleAnInt(double d) {
        return d == Math.floor(d) && !Double.isInfinite(d);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length == 2) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
        }
        if (valueEvalArray.length == 3) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1], valueEvalArray[2]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

