/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.functions;

import ai2.org.apache.poi.ss.formula.TwoDEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed0ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;

public abstract class BooleanFunction
implements Function {
    public static final Function AND = new BooleanFunction(){

        protected boolean getInitialResultValue() {
            return true;
        }

        protected boolean partialEvaluate(boolean bl, boolean bl2) {
            return bl && bl2;
        }
    };
    public static final Function OR = new BooleanFunction(){

        protected boolean getInitialResultValue() {
            return false;
        }

        protected boolean partialEvaluate(boolean bl, boolean bl2) {
            return bl || bl2;
        }
    };
    public static final Function FALSE = new Fixed0ArgFunction(){

        public ValueEval evaluate(int n, int n2) {
            return BoolEval.FALSE;
        }
    };
    public static final Function TRUE = new Fixed0ArgFunction(){

        public ValueEval evaluate(int n, int n2) {
            return BoolEval.TRUE;
        }
    };
    public static final Function NOT = new Fixed1ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            boolean bl;
            try {
                ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
                Boolean bl2 = OperandResolver.coerceValueToBoolean(valueEval2, false);
                bl = bl2 == null ? false : bl2;
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return BoolEval.valueOf(!bl);
        }
    };

    public final ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        boolean bl;
        if (valueEvalArray.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            bl = this.calculate(valueEvalArray);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return BoolEval.valueOf(bl);
    }

    private boolean calculate(ValueEval[] valueEvalArray) throws EvaluationException {
        boolean bl = this.getInitialResultValue();
        boolean bl2 = false;
        for (ValueEval valueEval : valueEvalArray) {
            Boolean bl3;
            int n;
            ValueEval valueEval2;
            if (valueEval instanceof TwoDEval) {
                valueEval2 = (TwoDEval)valueEval;
                n = valueEval2.getHeight();
                int n2 = valueEval2.getWidth();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        ValueEval valueEval3 = valueEval2.getValue(i, j);
                        bl3 = OperandResolver.coerceValueToBoolean(valueEval3, true);
                        if (bl3 == null) continue;
                        bl = this.partialEvaluate(bl, bl3);
                        bl2 = true;
                    }
                }
                continue;
            }
            if (valueEval instanceof RefEval) {
                valueEval2 = (RefEval)valueEval;
                for (n = valueEval2.getFirstSheetIndex(); n <= valueEval2.getLastSheetIndex(); ++n) {
                    ValueEval valueEval4 = valueEval2.getInnerValueEval(n);
                    bl3 = OperandResolver.coerceValueToBoolean(valueEval4, true);
                    if (bl3 == null) continue;
                    bl = this.partialEvaluate(bl, bl3);
                    bl2 = true;
                }
                continue;
            }
            bl3 = valueEval == MissingArgEval.instance ? null : OperandResolver.coerceValueToBoolean(valueEval, false);
            if (bl3 == null) continue;
            bl = this.partialEvaluate(bl, bl3);
            bl2 = true;
        }
        if (!bl2) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return bl;
    }

    protected abstract boolean getInitialResultValue();

    protected abstract boolean partialEvaluate(boolean var1, boolean var2);
}

