/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval.forked;

import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.EvaluationSheet;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationCell;
import ai2.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationSheet;
import ai2.org.apache.poi.ss.formula.ptg.NamePtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import java.util.HashMap;
import java.util.Map;

final class ForkedEvaluationWorkbook
implements EvaluationWorkbook {
    private final EvaluationWorkbook _masterBook;
    private final Map<String, ForkedEvaluationSheet> _sharedSheetsByName;

    public ForkedEvaluationWorkbook(EvaluationWorkbook evaluationWorkbook) {
        this._masterBook = evaluationWorkbook;
        this._sharedSheetsByName = new HashMap<String, ForkedEvaluationSheet>();
    }

    public ForkedEvaluationCell getOrCreateUpdatableCell(String string, int n, int n2) {
        ForkedEvaluationSheet forkedEvaluationSheet = this.getSharedSheet(string);
        return forkedEvaluationSheet.getOrCreateUpdatableCell(n, n2);
    }

    public EvaluationCell getEvaluationCell(String string, int n, int n2) {
        ForkedEvaluationSheet forkedEvaluationSheet = this.getSharedSheet(string);
        return forkedEvaluationSheet.getCell(n, n2);
    }

    private ForkedEvaluationSheet getSharedSheet(String string) {
        ForkedEvaluationSheet forkedEvaluationSheet = this._sharedSheetsByName.get(string);
        if (forkedEvaluationSheet == null) {
            forkedEvaluationSheet = new ForkedEvaluationSheet(this._masterBook.getSheet(this._masterBook.getSheetIndex(string)));
            this._sharedSheetsByName.put(string, forkedEvaluationSheet);
        }
        return forkedEvaluationSheet;
    }

    public void copyUpdatedCells(Workbook workbook) {
        String string;
        int n;
        String[] stringArray = new String[this._sharedSheetsByName.size()];
        this._sharedSheetsByName.keySet().toArray(stringArray);
        OrderedSheet[] orderedSheetArray = new OrderedSheet[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            orderedSheetArray[n] = new OrderedSheet(string, this._masterBook.getSheetIndex(string));
        }
        for (n = 0; n < orderedSheetArray.length; ++n) {
            string = orderedSheetArray[n].getSheetName();
            ForkedEvaluationSheet forkedEvaluationSheet = this._sharedSheetsByName.get(string);
            forkedEvaluationSheet.copyUpdatedCells(workbook.getSheet(string));
        }
    }

    public int convertFromExternSheetIndex(int n) {
        return this._masterBook.convertFromExternSheetIndex(n);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int n) {
        return this._masterBook.getExternalSheet(n);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(String string, String string2, int n) {
        return this._masterBook.getExternalSheet(string, string2, n);
    }

    public Ptg[] getFormulaTokens(EvaluationCell evaluationCell) {
        if (evaluationCell instanceof ForkedEvaluationCell) {
            throw new RuntimeException("Updated formulas not supported yet");
        }
        return this._masterBook.getFormulaTokens(evaluationCell);
    }

    public EvaluationName getName(NamePtg namePtg) {
        return this._masterBook.getName(namePtg);
    }

    public EvaluationName getName(String string, int n) {
        return this._masterBook.getName(string, n);
    }

    public EvaluationSheet getSheet(int n) {
        return this.getSharedSheet(this.getSheetName(n));
    }

    public EvaluationWorkbook.ExternalName getExternalName(int n, int n2) {
        return this._masterBook.getExternalName(n, n2);
    }

    public EvaluationWorkbook.ExternalName getExternalName(String string, String string2, int n) {
        return this._masterBook.getExternalName(string, string2, n);
    }

    public int getSheetIndex(EvaluationSheet evaluationSheet) {
        if (evaluationSheet instanceof ForkedEvaluationSheet) {
            ForkedEvaluationSheet forkedEvaluationSheet = (ForkedEvaluationSheet)evaluationSheet;
            return forkedEvaluationSheet.getSheetIndex(this._masterBook);
        }
        return this._masterBook.getSheetIndex(evaluationSheet);
    }

    public int getSheetIndex(String string) {
        return this._masterBook.getSheetIndex(string);
    }

    public String getSheetName(int n) {
        return this._masterBook.getSheetName(n);
    }

    public String resolveNameXText(NameXPtg nameXPtg) {
        return this._masterBook.resolveNameXText(nameXPtg);
    }

    public UDFFinder getUDFFinder() {
        return this._masterBook.getUDFFinder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderedSheet
    implements Comparable<OrderedSheet> {
        private final String _sheetName;
        private final int _index;

        public OrderedSheet(String string, int n) {
            this._sheetName = string;
            this._index = n;
        }

        public String getSheetName() {
            return this._sheetName;
        }

        @Override
        public int compareTo(OrderedSheet orderedSheet) {
            return this._index - orderedSheet._index;
        }
    }
}

