/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval.forked;

import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.EvaluationSheet;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationSheet;
import ai2.org.apache.poi.ss.usermodel.Cell;

final class ForkedEvaluationCell
implements EvaluationCell {
    private final EvaluationSheet _sheet;
    private final EvaluationCell _masterCell;
    private boolean _booleanValue;
    private int _cellType;
    private int _errorValue;
    private double _numberValue;
    private String _stringValue;

    public ForkedEvaluationCell(ForkedEvaluationSheet forkedEvaluationSheet, EvaluationCell evaluationCell) {
        this._sheet = forkedEvaluationSheet;
        this._masterCell = evaluationCell;
        this.setValue(BlankEval.instance);
    }

    public Object getIdentityKey() {
        return this._masterCell.getIdentityKey();
    }

    public void setValue(ValueEval valueEval) {
        Class<?> clazz = valueEval.getClass();
        if (clazz == NumberEval.class) {
            this._cellType = 0;
            this._numberValue = ((NumberEval)valueEval).getNumberValue();
            return;
        }
        if (clazz == StringEval.class) {
            this._cellType = 1;
            this._stringValue = ((StringEval)valueEval).getStringValue();
            return;
        }
        if (clazz == BoolEval.class) {
            this._cellType = 4;
            this._booleanValue = ((BoolEval)valueEval).getBooleanValue();
            return;
        }
        if (clazz == ErrorEval.class) {
            this._cellType = 5;
            this._errorValue = ((ErrorEval)valueEval).getErrorCode();
            return;
        }
        if (clazz == BlankEval.class) {
            this._cellType = 3;
            return;
        }
        throw new IllegalArgumentException("Unexpected value class (" + clazz.getName() + ")");
    }

    public void copyValue(Cell cell) {
        switch (this._cellType) {
            case 3: {
                cell.setCellType(3);
                return;
            }
            case 0: {
                cell.setCellValue(this._numberValue);
                return;
            }
            case 4: {
                cell.setCellValue(this._booleanValue);
                return;
            }
            case 1: {
                cell.setCellValue(this._stringValue);
                return;
            }
            case 5: {
                cell.setCellErrorValue((byte)this._errorValue);
                return;
            }
        }
        throw new IllegalStateException("Unexpected data type (" + this._cellType + ")");
    }

    private void checkCellType(int n) {
        if (this._cellType != n) {
            throw new RuntimeException("Wrong data type (" + this._cellType + ")");
        }
    }

    public int getCellType() {
        return this._cellType;
    }

    public boolean getBooleanCellValue() {
        this.checkCellType(4);
        return this._booleanValue;
    }

    public int getErrorCellValue() {
        this.checkCellType(5);
        return this._errorValue;
    }

    public double getNumericCellValue() {
        this.checkCellType(0);
        return this._numberValue;
    }

    public String getStringCellValue() {
        this.checkCellType(1);
        return this._stringValue;
    }

    public EvaluationSheet getSheet() {
        return this._sheet;
    }

    public int getRowIndex() {
        return this._masterCell.getRowIndex();
    }

    public int getColumnIndex() {
        return this._masterCell.getColumnIndex();
    }

    public int getCachedFormulaResultType() {
        return this._masterCell.getCachedFormulaResultType();
    }
}

