/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval;

import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import java.util.HashMap;
import java.util.Map;

public final class ErrorEval
implements ValueEval {
    private static final Map<FormulaError, ErrorEval> evals = new HashMap<FormulaError, ErrorEval>();
    public static final ErrorEval NULL_INTERSECTION = new ErrorEval(FormulaError.NULL);
    public static final ErrorEval DIV_ZERO = new ErrorEval(FormulaError.DIV0);
    public static final ErrorEval VALUE_INVALID = new ErrorEval(FormulaError.VALUE);
    public static final ErrorEval REF_INVALID = new ErrorEval(FormulaError.REF);
    public static final ErrorEval NAME_INVALID = new ErrorEval(FormulaError.NAME);
    public static final ErrorEval NUM_ERROR = new ErrorEval(FormulaError.NUM);
    public static final ErrorEval NA = new ErrorEval(FormulaError.NA);
    public static final ErrorEval FUNCTION_NOT_IMPLEMENTED = new ErrorEval(FormulaError.FUNCTION_NOT_IMPLEMENTED);
    public static final ErrorEval CIRCULAR_REF_ERROR = new ErrorEval(FormulaError.CIRCULAR_REF);
    private FormulaError _error;

    public static ErrorEval valueOf(int n) {
        FormulaError formulaError = FormulaError.forInt(n);
        ErrorEval errorEval = evals.get((Object)formulaError);
        if (errorEval != null) {
            return errorEval;
        }
        throw new RuntimeException("Unhandled error type " + errorEval + " for code " + n);
    }

    public static String getText(int n) {
        if (FormulaError.isValidCode(n)) {
            return FormulaError.forInt(n).getString();
        }
        return "~non~std~err(" + n + ")~";
    }

    private ErrorEval(FormulaError formulaError) {
        this._error = formulaError;
        evals.put(formulaError, this);
    }

    public int getErrorCode() {
        return this._error.getLongCode();
    }

    public String getErrorString() {
        return this._error.getString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this._error.getString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

