/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.atp;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.atp.DateParser;
import ai2.org.apache.poi.ss.formula.atp.YearFracCalculator;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;

final class YearFrac
implements FreeRefFunction {
    public static final FreeRefFunction instance = new YearFrac();

    private YearFrac() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        double d;
        int n = operationEvaluationContext.getRowIndex();
        int n2 = operationEvaluationContext.getColumnIndex();
        try {
            int n3 = 0;
            switch (valueEvalArray.length) {
                case 3: {
                    n3 = YearFrac.evaluateIntArg(valueEvalArray[2], n, n2);
                }
                case 2: {
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
            double d2 = YearFrac.evaluateDateArg(valueEvalArray[0], n, n2);
            double d3 = YearFrac.evaluateDateArg(valueEvalArray[1], n, n2);
            d = YearFracCalculator.calculate(d2, d3, n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static double evaluateDateArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, (short)n2);
        if (valueEval2 instanceof StringEval) {
            String string = ((StringEval)valueEval2).getStringValue();
            Double d = OperandResolver.parseDouble(string);
            if (d != null) {
                return d;
            }
            Calendar calendar = DateParser.parseDate(string);
            return DateUtil.getExcelDate(calendar, false);
        }
        return OperandResolver.coerceValueToDouble(valueEval2);
    }

    private static int evaluateIntArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, (short)n2);
        return OperandResolver.coerceValueToInt(valueEval2);
    }
}

