/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.atp;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.functions.NumericFunction;

final class MRound
implements FreeRefFunction {
    public static final FreeRefFunction instance = new MRound();

    private MRound() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d;
            double d2 = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()));
            double d3 = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(valueEvalArray[1], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()));
            if (d3 == 0.0) {
                d = 0.0;
            } else {
                if (d2 * d3 < 0.0) {
                    throw new EvaluationException(ErrorEval.NUM_ERROR);
                }
                d = d3 * (double)Math.round(d2 / d3);
            }
            NumericFunction.checkValue(d);
            return new NumberEval(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

