/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import ai2.org.apache.poi.ss.formula.EvaluationCache;
import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.EvaluationSheet;
import ai2.org.apache.poi.ss.formula.EvaluationTracker;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import ai2.org.apache.poi.ss.formula.IEvaluationListener;
import ai2.org.apache.poi.ss.formula.IStabilityClassifier;
import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.OperationEvaluatorFactory;
import ai2.org.apache.poi.ss.formula.atp.AnalysisToolPak;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.ExternalNameEval;
import ai2.org.apache.poi.ss.formula.eval.FunctionEval;
import ai2.org.apache.poi.ss.formula.eval.FunctionNameEval;
import ai2.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Choose;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.formula.functions.IfFunc;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPxg;
import ai2.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai2.org.apache.poi.ss.formula.ptg.BoolPtg;
import ai2.org.apache.poi.ss.formula.ptg.ControlPtg;
import ai2.org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.ErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.ExpPtg;
import ai2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai2.org.apache.poi.ss.formula.ptg.IntPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai2.org.apache.poi.ss.formula.ptg.MissingArgPtg;
import ai2.org.apache.poi.ss.formula.ptg.NamePtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPxg;
import ai2.org.apache.poi.ss.formula.ptg.NumberPtg;
import ai2.org.apache.poi.ss.formula.ptg.OperationPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import ai2.org.apache.poi.ss.formula.ptg.RefErrorPtg;
import ai2.org.apache.poi.ss.formula.ptg.RefPtg;
import ai2.org.apache.poi.ss.formula.ptg.StringPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnionPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnknownPtg;
import ai2.org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkbookEvaluator {
    private static final POILogger LOG = POILogFactory.getLogger(WorkbookEvaluator.class);
    private final EvaluationWorkbook _workbook;
    private EvaluationCache _cache;
    private int _workbookIx;
    private final IEvaluationListener _evaluationListener;
    private final Map<EvaluationSheet, Integer> _sheetIndexesBySheet;
    private final Map<String, Integer> _sheetIndexesByName;
    private CollaboratingWorkbooksEnvironment _collaboratingWorkbookEnvironment;
    private final IStabilityClassifier _stabilityClassifier;
    private final AggregatingUDFFinder _udfFinder;
    private boolean _ignoreMissingWorkbooks = false;
    private boolean dbgEvaluationOutputForNextEval = false;
    private final POILogger EVAL_LOG = POILogFactory.getLogger("POI.FormulaEval");
    private int dbgEvaluationOutputIndent = -1;

    public WorkbookEvaluator(EvaluationWorkbook evaluationWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        this(evaluationWorkbook, null, iStabilityClassifier, uDFFinder);
    }

    WorkbookEvaluator(EvaluationWorkbook evaluationWorkbook, IEvaluationListener iEvaluationListener, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        AggregatingUDFFinder aggregatingUDFFinder;
        this._workbook = evaluationWorkbook;
        this._evaluationListener = iEvaluationListener;
        this._cache = new EvaluationCache(iEvaluationListener);
        this._sheetIndexesBySheet = new IdentityHashMap<EvaluationSheet, Integer>();
        this._sheetIndexesByName = new IdentityHashMap<String, Integer>();
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._workbookIx = 0;
        this._stabilityClassifier = iStabilityClassifier;
        AggregatingUDFFinder aggregatingUDFFinder2 = aggregatingUDFFinder = evaluationWorkbook == null ? null : (AggregatingUDFFinder)evaluationWorkbook.getUDFFinder();
        if (aggregatingUDFFinder != null && uDFFinder != null) {
            aggregatingUDFFinder.add(uDFFinder);
        }
        this._udfFinder = aggregatingUDFFinder;
    }

    String getSheetName(int n) {
        return this._workbook.getSheetName(n);
    }

    EvaluationSheet getSheet(int n) {
        return this._workbook.getSheet(n);
    }

    EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    EvaluationName getName(String string, int n) {
        EvaluationName evaluationName = this._workbook.getName(string, n);
        return evaluationName;
    }

    private static boolean isDebugLogEnabled() {
        return LOG.check(1);
    }

    private static boolean isInfoLogEnabled() {
        return LOG.check(3);
    }

    private static void logDebug(String string) {
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            LOG.log(1, new Object[]{string});
        }
    }

    private static void logInfo(String string) {
        if (WorkbookEvaluator.isInfoLogEnabled()) {
            LOG.log(3, new Object[]{string});
        }
    }

    void attachToEnvironment(CollaboratingWorkbooksEnvironment collaboratingWorkbooksEnvironment, EvaluationCache evaluationCache, int n) {
        this._collaboratingWorkbookEnvironment = collaboratingWorkbooksEnvironment;
        this._cache = evaluationCache;
        this._workbookIx = n;
    }

    CollaboratingWorkbooksEnvironment getEnvironment() {
        return this._collaboratingWorkbookEnvironment;
    }

    void detachFromEnvironment() {
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._cache = new EvaluationCache(this._evaluationListener);
        this._workbookIx = 0;
    }

    WorkbookEvaluator getOtherWorkbookEvaluator(String string) throws CollaboratingWorkbooksEnvironment.WorkbookNotFoundException {
        return this._collaboratingWorkbookEnvironment.getWorkbookEvaluator(string);
    }

    IEvaluationListener getEvaluationListener() {
        return this._evaluationListener;
    }

    public void clearAllCachedResultValues() {
        this._cache.clear();
        this._sheetIndexesBySheet.clear();
    }

    public void notifyUpdateCell(EvaluationCell evaluationCell) {
        int n = this.getSheetIndex(evaluationCell.getSheet());
        this._cache.notifyUpdateCell(this._workbookIx, n, evaluationCell);
    }

    public void notifyDeleteCell(EvaluationCell evaluationCell) {
        int n = this.getSheetIndex(evaluationCell.getSheet());
        this._cache.notifyDeleteCell(this._workbookIx, n, evaluationCell);
    }

    private int getSheetIndex(EvaluationSheet evaluationSheet) {
        Integer n = this._sheetIndexesBySheet.get(evaluationSheet);
        if (n == null) {
            int n2 = this._workbook.getSheetIndex(evaluationSheet);
            if (n2 < 0) {
                throw new RuntimeException("Specified sheet from a different book");
            }
            n = n2;
            this._sheetIndexesBySheet.put(evaluationSheet, n);
        }
        return n;
    }

    public ValueEval evaluate(EvaluationCell evaluationCell) {
        int n = this.getSheetIndex(evaluationCell.getSheet());
        return this.evaluateAny(evaluationCell, n, evaluationCell.getRowIndex(), evaluationCell.getColumnIndex(), new EvaluationTracker(this._cache));
    }

    int getSheetIndex(String string) {
        Integer n = this._sheetIndexesByName.get(string);
        if (n == null) {
            int n2 = this._workbook.getSheetIndex(string);
            if (n2 < 0) {
                return -1;
            }
            n = n2;
            this._sheetIndexesByName.put(string, n);
        }
        return n;
    }

    int getSheetIndexByExternIndex(int n) {
        return this._workbook.convertFromExternSheetIndex(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueEval evaluateAny(EvaluationCell evaluationCell, int n, int n2, int n3, EvaluationTracker evaluationTracker) {
        ValueEval valueEval;
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = this._stabilityClassifier == null ? true : (bl = !this._stabilityClassifier.isCellFinal(n, n2, n3));
        if (evaluationCell == null || evaluationCell.getCellType() != 2) {
            ValueEval valueEval2 = WorkbookEvaluator.getValueFromNonFormulaCell(evaluationCell);
            if (bl) {
                evaluationTracker.acceptPlainValueDependency(this._workbookIx, n, n2, n3, valueEval2);
            }
            return valueEval2;
        }
        FormulaCellCacheEntry formulaCellCacheEntry = this._cache.getOrCreateFormulaCellEntry(evaluationCell);
        if (bl || formulaCellCacheEntry.isInputSensitive()) {
            evaluationTracker.acceptFormulaDependency(formulaCellCacheEntry);
        }
        IEvaluationListener iEvaluationListener = this._evaluationListener;
        if (formulaCellCacheEntry.getValue() == null) {
            if (!evaluationTracker.startEvaluate(formulaCellCacheEntry)) {
                return ErrorEval.CIRCULAR_REF_ERROR;
            }
            object2 = new OperationEvaluationContext(this, this._workbook, n, n2, n3, evaluationTracker);
            try {
                object = this._workbook.getFormulaTokens(evaluationCell);
                if (iEvaluationListener == null) {
                    valueEval = this.evaluateFormula((OperationEvaluationContext)object2, (Ptg[])object);
                } else {
                    iEvaluationListener.onStartEvaluate(evaluationCell, formulaCellCacheEntry);
                    valueEval = this.evaluateFormula((OperationEvaluationContext)object2, (Ptg[])object);
                    iEvaluationListener.onEndEvaluate(formulaCellCacheEntry, valueEval);
                }
                evaluationTracker.updateCacheResult(valueEval);
            }
            catch (NotImplementedException notImplementedException) {
                throw this.addExceptionInfo(notImplementedException, n, n2, n3);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException && this._ignoreMissingWorkbooks) {
                    WorkbookEvaluator.logInfo(runtimeException.getCause().getMessage() + " - Continuing with cached value!");
                    switch (evaluationCell.getCachedFormulaResultType()) {
                        case 0: {
                            valueEval = new NumberEval(evaluationCell.getNumericCellValue());
                        }
                        case 1: {
                            valueEval = new StringEval(evaluationCell.getStringCellValue());
                        }
                        case 3: {
                            valueEval = BlankEval.instance;
                        }
                        case 4: {
                            valueEval = BoolEval.valueOf(evaluationCell.getBooleanCellValue());
                        }
                        case 5: {
                            valueEval = ErrorEval.valueOf(evaluationCell.getErrorCellValue());
                        }
                        default: {
                            throw new RuntimeException("Unexpected cell type '" + evaluationCell.getCellType() + "' found!");
                        }
                    }
                }
                throw runtimeException;
            }
            finally {
                evaluationTracker.endEvaluate(formulaCellCacheEntry);
            }
        } else {
            if (iEvaluationListener != null) {
                iEvaluationListener.onCacheHit(n, n2, n3, formulaCellCacheEntry.getValue());
            }
            return formulaCellCacheEntry.getValue();
        }
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            object2 = this.getSheetName(n);
            object = new CellReference(n2, n3);
            WorkbookEvaluator.logDebug("Evaluated " + (String)object2 + "!" + ((CellReference)object).formatAsString() + " to " + valueEval.toString());
        }
        return valueEval;
    }

    private NotImplementedException addExceptionInfo(NotImplementedException notImplementedException, int n, int n2, int n3) {
        try {
            String string = this._workbook.getSheetName(n);
            CellReference cellReference = new CellReference(string, n2, n3, false, false);
            String string2 = "Error evaluating cell " + cellReference.formatAsString();
            return new NotImplementedException(string2, notImplementedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return notImplementedException;
        }
    }

    static ValueEval getValueFromNonFormulaCell(EvaluationCell evaluationCell) {
        if (evaluationCell == null) {
            return BlankEval.instance;
        }
        int n = evaluationCell.getCellType();
        switch (n) {
            case 0: {
                return new NumberEval(evaluationCell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(evaluationCell.getStringCellValue());
            }
            case 4: {
                return BoolEval.valueOf(evaluationCell.getBooleanCellValue());
            }
            case 3: {
                return BlankEval.instance;
            }
            case 5: {
                return ErrorEval.valueOf(evaluationCell.getErrorCellValue());
            }
        }
        throw new RuntimeException("Unexpected cell type (" + n + ")");
    }

    ValueEval evaluateFormula(OperationEvaluationContext operationEvaluationContext, Ptg[] ptgArray) {
        String string = "";
        if (this.dbgEvaluationOutputForNextEval) {
            this.dbgEvaluationOutputIndent = 1;
            this.dbgEvaluationOutputForNextEval = false;
        }
        if (this.dbgEvaluationOutputIndent > 0) {
            string = "                                                                                                    ";
            string = string.substring(0, Math.min(string.length(), this.dbgEvaluationOutputIndent * 2));
            this.EVAL_LOG.log(5, new Object[]{string + "- evaluateFormula('" + operationEvaluationContext.getRefEvaluatorForCurrentSheet().getSheetNameRange() + "'/" + new CellReference(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()).formatAsString() + "): " + Arrays.toString(ptgArray).replaceAll("\\Qai2.org.apache.poi.ss.formula.ptg.\\E", "")});
            ++this.dbgEvaluationOutputIndent;
        }
        Stack<Object> stack = new Stack<Object>();
        int n = ptgArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            Ptg ptg = ptgArray[i];
            if (this.dbgEvaluationOutputIndent > 0) {
                this.EVAL_LOG.log(3, new Object[]{string + "  * ptg " + i + ": " + ptg});
            }
            if (ptg instanceof AttrPtg) {
                object = (AttrPtg)ptg;
                if (((AttrPtg)object).isSum()) {
                    ptg = FuncVarPtg.SUM;
                }
                if (((AttrPtg)object).isOptimizedChoose()) {
                    int n3;
                    ValueEval valueEval = (ValueEval)stack.pop();
                    int[] nArray = ((AttrPtg)object).getJumpTable();
                    int n4 = nArray.length;
                    try {
                        int n5 = Choose.evaluateFirstArg(valueEval, operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
                        if (n5 < 1 || n5 > n4) {
                            stack.push(ErrorEval.VALUE_INVALID);
                            n3 = ((AttrPtg)object).getChooseFuncOffset() + 4;
                        } else {
                            n3 = nArray[n5 - 1];
                        }
                    }
                    catch (EvaluationException evaluationException) {
                        stack.push(evaluationException.getErrorEval());
                        n3 = ((AttrPtg)object).getChooseFuncOffset() + 4;
                    }
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgArray, i, n3 -= n4 * 2 + 2);
                    continue;
                }
                if (((AttrPtg)object).isOptimizedIf()) {
                    ValueEval valueEval = (ValueEval)stack.pop();
                    try {
                        n2 = IfFunc.evaluateFirstArg(valueEval, operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
                    }
                    catch (EvaluationException evaluationException) {
                        stack.push(evaluationException.getErrorEval());
                        int n6 = ((AttrPtg)object).getData();
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgArray, i, n6);
                        object = (AttrPtg)ptgArray[i];
                        n6 = ((AttrPtg)object).getData() + 1;
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgArray, i, n6);
                        continue;
                    }
                    if (n2 != 0) continue;
                    short s = ((AttrPtg)object).getData();
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgArray, i, s);
                    Ptg ptg2 = ptgArray[i + 1];
                    if (!(ptgArray[i] instanceof AttrPtg) || !(ptg2 instanceof FuncVarPtg) || ((FuncVarPtg)ptg2).getFunctionIndex() != 1) continue;
                    ++i;
                    stack.push(BoolEval.FALSE);
                    continue;
                }
                if (((AttrPtg)object).isSkip()) {
                    int n7 = ((AttrPtg)object).getData() + 1;
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgArray, i, n7);
                    if (stack.peek() != MissingArgEval.instance) continue;
                    stack.pop();
                    stack.push(BlankEval.instance);
                    continue;
                }
            }
            if (ptg instanceof ControlPtg || ptg instanceof MemFuncPtg || ptg instanceof MemAreaPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof OperationPtg) {
                OperationPtg operationPtg = (OperationPtg)ptg;
                if (operationPtg instanceof UnionPtg) continue;
                n2 = operationPtg.getNumberOfOperands();
                ValueEval[] valueEvalArray = new ValueEval[n2];
                for (int j = n2 - 1; j >= 0; --j) {
                    ValueEval valueEval;
                    valueEvalArray[j] = valueEval = (ValueEval)stack.pop();
                }
                object = OperationEvaluatorFactory.evaluate(operationPtg, valueEvalArray, operationEvaluationContext);
            } else {
                object = this.getEvalForPtg(ptg, operationEvaluationContext);
            }
            if (object == null) {
                throw new RuntimeException("Evaluation result must not be null");
            }
            stack.push(object);
            if (this.dbgEvaluationOutputIndent <= 0) continue;
            this.EVAL_LOG.log(3, new Object[]{string + "    = " + object});
        }
        ValueEval valueEval = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        ValueEval valueEval2 = WorkbookEvaluator.dereferenceResult(valueEval, operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
        if (this.dbgEvaluationOutputIndent > 0) {
            this.EVAL_LOG.log(3, new Object[]{string + "finshed eval of " + new CellReference(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()).formatAsString() + ": " + valueEval2});
            --this.dbgEvaluationOutputIndent;
            if (this.dbgEvaluationOutputIndent == 1) {
                this.dbgEvaluationOutputIndent = -1;
            }
        }
        return valueEval2;
    }

    private static int countTokensToBeSkipped(Ptg[] ptgArray, int n, int n2) {
        int n3 = n2;
        int n4 = n;
        while (n3 != 0) {
            if ((n3 -= ptgArray[++n4].getSize()) < 0) {
                throw new RuntimeException("Bad skip distance (wrong token size calculation).");
            }
            if (n4 < ptgArray.length) continue;
            throw new RuntimeException("Skip distance too far (ran out of formula tokens).");
        }
        return n4 - n;
    }

    public static ValueEval dereferenceResult(ValueEval valueEval, int n, int n2) {
        ValueEval valueEval2;
        try {
            valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (valueEval2 == BlankEval.instance) {
            return NumberEval.ZERO;
        }
        return valueEval2;
    }

    private ValueEval getEvalForPtg(Ptg ptg, OperationEvaluationContext operationEvaluationContext) {
        if (ptg instanceof NamePtg) {
            NamePtg namePtg = (NamePtg)ptg;
            EvaluationName evaluationName = this._workbook.getName(namePtg);
            return this.getEvalForNameRecord(evaluationName, operationEvaluationContext);
        }
        if (ptg instanceof NameXPtg) {
            return this.processNameEval(operationEvaluationContext.getNameXEval((NameXPtg)ptg), operationEvaluationContext);
        }
        if (ptg instanceof NameXPxg) {
            return this.processNameEval(operationEvaluationContext.getNameXEval((NameXPxg)ptg), operationEvaluationContext);
        }
        if (ptg instanceof IntPtg) {
            return new NumberEval(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new NumberEval(((NumberPtg)ptg).getValue());
        }
        if (ptg instanceof StringPtg) {
            return new StringEval(((StringPtg)ptg).getValue());
        }
        if (ptg instanceof BoolPtg) {
            return BoolEval.valueOf(((BoolPtg)ptg).getValue());
        }
        if (ptg instanceof ErrPtg) {
            return ErrorEval.valueOf(((ErrPtg)ptg).getErrorCode());
        }
        if (ptg instanceof MissingArgPtg) {
            return MissingArgEval.instance;
        }
        if (ptg instanceof AreaErrPtg || ptg instanceof RefErrorPtg || ptg instanceof DeletedArea3DPtg || ptg instanceof DeletedRef3DPtg) {
            return ErrorEval.REF_INVALID;
        }
        if (ptg instanceof Ref3DPtg) {
            return operationEvaluationContext.getRef3DEval((Ref3DPtg)ptg);
        }
        if (ptg instanceof Ref3DPxg) {
            return operationEvaluationContext.getRef3DEval((Ref3DPxg)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            return operationEvaluationContext.getArea3DEval((Area3DPtg)ptg);
        }
        if (ptg instanceof Area3DPxg) {
            return operationEvaluationContext.getArea3DEval((Area3DPxg)ptg);
        }
        if (ptg instanceof RefPtg) {
            RefPtg refPtg = (RefPtg)ptg;
            return operationEvaluationContext.getRefEval(refPtg.getRow(), refPtg.getColumn());
        }
        if (ptg instanceof AreaPtg) {
            AreaPtg areaPtg = (AreaPtg)ptg;
            return operationEvaluationContext.getAreaEval(areaPtg.getFirstRow(), areaPtg.getFirstColumn(), areaPtg.getLastRow(), areaPtg.getLastColumn());
        }
        if (ptg instanceof UnknownPtg) {
            throw new RuntimeException("UnknownPtg not allowed");
        }
        if (ptg instanceof ExpPtg) {
            throw new RuntimeException("ExpPtg currently not supported");
        }
        throw new RuntimeException("Unexpected ptg class (" + ptg.getClass().getName() + ")");
    }

    private ValueEval processNameEval(ValueEval valueEval, OperationEvaluationContext operationEvaluationContext) {
        if (valueEval instanceof ExternalNameEval) {
            EvaluationName evaluationName = ((ExternalNameEval)valueEval).getName();
            return this.getEvalForNameRecord(evaluationName, operationEvaluationContext);
        }
        return valueEval;
    }

    private ValueEval getEvalForNameRecord(EvaluationName evaluationName, OperationEvaluationContext operationEvaluationContext) {
        if (evaluationName.isFunctionName()) {
            return new FunctionNameEval(evaluationName.getNameText());
        }
        if (evaluationName.hasFormula()) {
            return this.evaluateNameFormula(evaluationName.getNameDefinition(), operationEvaluationContext);
        }
        throw new RuntimeException("Don't now how to evalate name '" + evaluationName.getNameText() + "'");
    }

    ValueEval evaluateNameFormula(Ptg[] ptgArray, OperationEvaluationContext operationEvaluationContext) {
        if (ptgArray.length == 1) {
            return this.getEvalForPtg(ptgArray[0], operationEvaluationContext);
        }
        return this.evaluateFormula(operationEvaluationContext, ptgArray);
    }

    ValueEval evaluateReference(EvaluationSheet evaluationSheet, int n, int n2, int n3, EvaluationTracker evaluationTracker) {
        EvaluationCell evaluationCell = evaluationSheet.getCell(n2, n3);
        return this.evaluateAny(evaluationCell, n, n2, n3, evaluationTracker);
    }

    public FreeRefFunction findUserDefinedFunction(String string) {
        return this._udfFinder.findFunction(string);
    }

    public void setIgnoreMissingWorkbooks(boolean bl) {
        this._ignoreMissingWorkbooks = bl;
    }

    public static Collection<String> getSupportedFunctionNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(FunctionEval.getSupportedFunctionNames());
        treeSet.addAll(AnalysisToolPak.getSupportedFunctionNames());
        return treeSet;
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(FunctionEval.getNotSupportedFunctionNames());
        treeSet.addAll(AnalysisToolPak.getNotSupportedFunctionNames());
        return treeSet;
    }

    public static void registerFunction(String string, FreeRefFunction freeRefFunction) {
        AnalysisToolPak.registerFunction(string, freeRefFunction);
    }

    public static void registerFunction(String string, Function function) {
        FunctionEval.registerFunction(string, function);
    }

    public void setDebugEvaluationOutputForNextEval(boolean bl) {
        this.dbgEvaluationOutputForNextEval = bl;
    }
}

