/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.util.CellReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SheetNameFormatter {
    private static final char DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Za-z]+)([0-9]+)");

    private SheetNameFormatter() {
    }

    public static String format(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        SheetNameFormatter.appendFormat(stringBuffer, string);
        return stringBuffer.toString();
    }

    public static void appendFormat(StringBuffer stringBuffer, String string) {
        boolean bl = SheetNameFormatter.needsDelimiting(string);
        if (bl) {
            stringBuffer.append('\'');
            SheetNameFormatter.appendAndEscape(stringBuffer, string);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append(string);
        }
    }

    public static void appendFormat(StringBuffer stringBuffer, String string, String string2) {
        boolean bl;
        boolean bl2 = bl = SheetNameFormatter.needsDelimiting(string) || SheetNameFormatter.needsDelimiting(string2);
        if (bl) {
            stringBuffer.append('\'');
            stringBuffer.append('[');
            SheetNameFormatter.appendAndEscape(stringBuffer, string.replace('[', '(').replace(']', ')'));
            stringBuffer.append(']');
            SheetNameFormatter.appendAndEscape(stringBuffer, string2);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append('[');
            stringBuffer.append(string);
            stringBuffer.append(']');
            stringBuffer.append(string2);
        }
    }

    private static void appendAndEscape(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c);
        }
    }

    private static boolean needsDelimiting(String string) {
        int n = string.length();
        if (n < 1) {
            throw new RuntimeException("Zero length string is an invalid sheet name");
        }
        if (Character.isDigit(string.charAt(0))) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!SheetNameFormatter.isSpecialChar(c)) continue;
            return true;
        }
        if (Character.isLetter(string.charAt(0)) && Character.isDigit(string.charAt(n - 1)) && SheetNameFormatter.nameLooksLikePlainCellReference(string)) {
            return true;
        }
        return SheetNameFormatter.nameLooksLikeBooleanLiteral(string);
    }

    private static boolean nameLooksLikeBooleanLiteral(String string) {
        switch (string.charAt(0)) {
            case 'T': 
            case 't': {
                return "TRUE".equalsIgnoreCase(string);
            }
            case 'F': 
            case 'f': {
                return "FALSE".equalsIgnoreCase(string);
            }
        }
        return false;
    }

    static boolean isSpecialChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        switch (c) {
            case '.': 
            case '_': {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                throw new RuntimeException("Illegal character (0x" + Integer.toHexString(c) + ") found in sheet name");
            }
        }
        return true;
    }

    static boolean cellReferenceIsWithinRange(String string, String string2) {
        return CellReference.cellReferenceIsWithinRange(string, string2, SpreadsheetVersion.EXCEL97);
    }

    static boolean nameLooksLikePlainCellReference(String string) {
        Matcher matcher = CELL_REF_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        return SheetNameFormatter.cellReferenceIsWithinRange(string2, string3);
    }
}

