/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.EvaluationTracker;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.ExternSheetReferenceToken;
import ai2.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import ai2.org.apache.poi.ss.formula.LazyAreaEval;
import ai2.org.apache.poi.ss.formula.LazyRefEval;
import ai2.org.apache.poi.ss.formula.SheetRangeEvaluator;
import ai2.org.apache.poi.ss.formula.SheetRefEvaluator;
import ai2.org.apache.poi.ss.formula.UserDefinedFunction;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.ExternalNameEval;
import ai2.org.apache.poi.ss.formula.eval.FunctionNameEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPxg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPxg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import ai2.org.apache.poi.ss.util.CellReference;

public final class OperationEvaluationContext {
    public static final FreeRefFunction UDF = UserDefinedFunction.instance;
    private final EvaluationWorkbook _workbook;
    private final int _sheetIndex;
    private final int _rowIndex;
    private final int _columnIndex;
    private final EvaluationTracker _tracker;
    private final WorkbookEvaluator _bookEvaluator;

    public OperationEvaluationContext(WorkbookEvaluator workbookEvaluator, EvaluationWorkbook evaluationWorkbook, int n, int n2, int n3, EvaluationTracker evaluationTracker) {
        this._bookEvaluator = workbookEvaluator;
        this._workbook = evaluationWorkbook;
        this._sheetIndex = n;
        this._rowIndex = n2;
        this._columnIndex = n3;
        this._tracker = evaluationTracker;
    }

    public EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    SheetRangeEvaluator createExternSheetRefEvaluator(ExternSheetReferenceToken externSheetReferenceToken) {
        return this.createExternSheetRefEvaluator(externSheetReferenceToken.getExternSheetIndex());
    }

    SheetRangeEvaluator createExternSheetRefEvaluator(String string, String string2, int n) {
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(string, string2, n);
        return this.createExternSheetRefEvaluator(externalSheet);
    }

    SheetRangeEvaluator createExternSheetRefEvaluator(int n) {
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(n);
        return this.createExternSheetRefEvaluator(externalSheet);
    }

    SheetRangeEvaluator createExternSheetRefEvaluator(EvaluationWorkbook.ExternalSheet externalSheet) {
        SheetRefEvaluator[] sheetRefEvaluatorArray;
        int n;
        WorkbookEvaluator workbookEvaluator;
        int n2 = -1;
        if (externalSheet == null || externalSheet.getWorkbookName() == null) {
            workbookEvaluator = this._bookEvaluator;
            n = externalSheet == null ? 0 : this._workbook.getSheetIndex(externalSheet.getSheetName());
            if (externalSheet instanceof EvaluationWorkbook.ExternalSheetRange) {
                sheetRefEvaluatorArray = ((EvaluationWorkbook.ExternalSheetRange)externalSheet).getLastSheetName();
                n2 = this._workbook.getSheetIndex((String)sheetRefEvaluatorArray);
            }
        } else {
            sheetRefEvaluatorArray = externalSheet.getWorkbookName();
            try {
                workbookEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator((String)sheetRefEvaluatorArray);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException workbookNotFoundException) {
                throw new RuntimeException(workbookNotFoundException.getMessage(), workbookNotFoundException);
            }
            n = workbookEvaluator.getSheetIndex(externalSheet.getSheetName());
            if (externalSheet instanceof EvaluationWorkbook.ExternalSheetRange) {
                String string = ((EvaluationWorkbook.ExternalSheetRange)externalSheet).getLastSheetName();
                n2 = workbookEvaluator.getSheetIndex(string);
            }
            if (n < 0) {
                throw new RuntimeException("Invalid sheet name '" + externalSheet.getSheetName() + "' in bool '" + (String)sheetRefEvaluatorArray + "'.");
            }
        }
        if (n2 == -1) {
            n2 = n;
        }
        sheetRefEvaluatorArray = new SheetRefEvaluator[n2 - n + 1];
        for (int i = 0; i < sheetRefEvaluatorArray.length; ++i) {
            int n3 = i + n;
            sheetRefEvaluatorArray[i] = new SheetRefEvaluator(workbookEvaluator, this._tracker, n3);
        }
        return new SheetRangeEvaluator(n, n2, sheetRefEvaluatorArray);
    }

    private SheetRefEvaluator createExternSheetRefEvaluator(String string, String string2) {
        int n;
        WorkbookEvaluator workbookEvaluator;
        if (string == null) {
            workbookEvaluator = this._bookEvaluator;
        } else {
            if (string2 == null) {
                throw new IllegalArgumentException("sheetName must not be null if workbookName is provided");
            }
            try {
                workbookEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(string);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException workbookNotFoundException) {
                return null;
            }
        }
        int n2 = n = string2 == null ? this._sheetIndex : workbookEvaluator.getSheetIndex(string2);
        if (n < 0) {
            return null;
        }
        return new SheetRefEvaluator(workbookEvaluator, this._tracker, n);
    }

    public SheetRangeEvaluator getRefEvaluatorForCurrentSheet() {
        SheetRefEvaluator sheetRefEvaluator = new SheetRefEvaluator(this._bookEvaluator, this._tracker, this._sheetIndex);
        return new SheetRangeEvaluator(this._sheetIndex, sheetRefEvaluator);
    }

    public ValueEval getDynamicReference(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!bl) {
            throw new RuntimeException("R1C1 style not supported yet");
        }
        SheetRefEvaluator sheetRefEvaluator = this.createExternSheetRefEvaluator(string, string2);
        if (sheetRefEvaluator == null) {
            return ErrorEval.REF_INVALID;
        }
        SheetRangeEvaluator sheetRangeEvaluator = new SheetRangeEvaluator(this._sheetIndex, sheetRefEvaluator);
        SpreadsheetVersion spreadsheetVersion = ((FormulaParsingWorkbook)((Object)this._workbook)).getSpreadsheetVersion();
        CellReference.NameType nameType = OperationEvaluationContext.classifyCellReference(string3, spreadsheetVersion);
        switch (nameType) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                EvaluationName evaluationName = ((FormulaParsingWorkbook)((Object)this._workbook)).getName(string3, this._sheetIndex);
                if (!evaluationName.isRange()) {
                    throw new RuntimeException("Specified name '" + string3 + "' is not a range as expected.");
                }
                return this._bookEvaluator.evaluateNameFormula(evaluationName.getNameDefinition(), this);
            }
        }
        if (string4 == null) {
            switch (nameType) {
                case COLUMN: 
                case ROW: {
                    return ErrorEval.REF_INVALID;
                }
                case CELL: {
                    CellReference cellReference = new CellReference(string3);
                    return new LazyRefEval(cellReference.getRow(), (int)cellReference.getCol(), sheetRangeEvaluator);
                }
            }
            throw new IllegalStateException("Unexpected reference classification of '" + string3 + "'.");
        }
        CellReference.NameType nameType2 = OperationEvaluationContext.classifyCellReference(string3, spreadsheetVersion);
        switch (nameType2) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                throw new RuntimeException("Cannot evaluate '" + string3 + "'. Indirect evaluation of defined names not supported yet");
            }
        }
        if (nameType2 != nameType) {
            return ErrorEval.REF_INVALID;
        }
        switch (nameType) {
            case COLUMN: {
                n4 = 0;
                if (nameType2.equals((Object)CellReference.NameType.COLUMN)) {
                    n3 = spreadsheetVersion.getLastRowIndex();
                    n2 = OperationEvaluationContext.parseRowRef(string3);
                    n = OperationEvaluationContext.parseRowRef(string4);
                    break;
                }
                n3 = spreadsheetVersion.getLastRowIndex();
                n2 = OperationEvaluationContext.parseColRef(string3);
                n = OperationEvaluationContext.parseColRef(string4);
                break;
            }
            case ROW: {
                n2 = 0;
                if (nameType2.equals((Object)CellReference.NameType.ROW)) {
                    n4 = OperationEvaluationContext.parseColRef(string3);
                    n3 = OperationEvaluationContext.parseColRef(string4);
                    n = spreadsheetVersion.getLastColumnIndex();
                    break;
                }
                n = spreadsheetVersion.getLastColumnIndex();
                n4 = OperationEvaluationContext.parseRowRef(string3);
                n3 = OperationEvaluationContext.parseRowRef(string4);
                break;
            }
            case CELL: {
                CellReference cellReference = new CellReference(string3);
                n4 = cellReference.getRow();
                n2 = cellReference.getCol();
                cellReference = new CellReference(string4);
                n3 = cellReference.getRow();
                n = cellReference.getCol();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected reference classification of '" + string3 + "'.");
            }
        }
        return new LazyAreaEval(n4, n2, n3, n, sheetRangeEvaluator);
    }

    private static int parseRowRef(String string) {
        return CellReference.convertColStringToIndex(string);
    }

    private static int parseColRef(String string) {
        return Integer.parseInt(string) - 1;
    }

    private static CellReference.NameType classifyCellReference(String string, SpreadsheetVersion spreadsheetVersion) {
        int n = string.length();
        if (n < 1) {
            return CellReference.NameType.BAD_CELL_OR_NAMED_RANGE;
        }
        return CellReference.classifyCellReference(string, spreadsheetVersion);
    }

    public FreeRefFunction findUserDefinedFunction(String string) {
        return this._bookEvaluator.findUserDefinedFunction(string);
    }

    public ValueEval getRefEval(int n, int n2) {
        SheetRangeEvaluator sheetRangeEvaluator = this.getRefEvaluatorForCurrentSheet();
        return new LazyRefEval(n, n2, sheetRangeEvaluator);
    }

    public ValueEval getRef3DEval(Ref3DPtg ref3DPtg) {
        SheetRangeEvaluator sheetRangeEvaluator = this.createExternSheetRefEvaluator(ref3DPtg.getExternSheetIndex());
        return new LazyRefEval(ref3DPtg.getRow(), ref3DPtg.getColumn(), sheetRangeEvaluator);
    }

    public ValueEval getRef3DEval(Ref3DPxg ref3DPxg) {
        SheetRangeEvaluator sheetRangeEvaluator = this.createExternSheetRefEvaluator(ref3DPxg.getSheetName(), ref3DPxg.getLastSheetName(), ref3DPxg.getExternalWorkbookNumber());
        return new LazyRefEval(ref3DPxg.getRow(), ref3DPxg.getColumn(), sheetRangeEvaluator);
    }

    public ValueEval getAreaEval(int n, int n2, int n3, int n4) {
        SheetRangeEvaluator sheetRangeEvaluator = this.getRefEvaluatorForCurrentSheet();
        return new LazyAreaEval(n, n2, n3, n4, sheetRangeEvaluator);
    }

    public ValueEval getArea3DEval(Area3DPtg area3DPtg) {
        SheetRangeEvaluator sheetRangeEvaluator = this.createExternSheetRefEvaluator(area3DPtg.getExternSheetIndex());
        return new LazyAreaEval(area3DPtg.getFirstRow(), area3DPtg.getFirstColumn(), area3DPtg.getLastRow(), area3DPtg.getLastColumn(), sheetRangeEvaluator);
    }

    public ValueEval getArea3DEval(Area3DPxg area3DPxg) {
        SheetRangeEvaluator sheetRangeEvaluator = this.createExternSheetRefEvaluator(area3DPxg.getSheetName(), area3DPxg.getLastSheetName(), area3DPxg.getExternalWorkbookNumber());
        return new LazyAreaEval(area3DPxg.getFirstRow(), area3DPxg.getFirstColumn(), area3DPxg.getLastRow(), area3DPxg.getLastColumn(), sheetRangeEvaluator);
    }

    public ValueEval getNameXEval(NameXPtg nameXPtg) {
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(nameXPtg.getSheetRefIndex());
        if (externalSheet == null || externalSheet.getWorkbookName() == null) {
            return this.getLocalNameXEval(nameXPtg);
        }
        String string = externalSheet.getWorkbookName();
        EvaluationWorkbook.ExternalName externalName = this._workbook.getExternalName(nameXPtg.getSheetRefIndex(), nameXPtg.getNameIndex());
        return this.getExternalNameXEval(externalName, string);
    }

    public ValueEval getNameXEval(NameXPxg nameXPxg) {
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(nameXPxg.getSheetName(), null, nameXPxg.getExternalWorkbookNumber());
        if (externalSheet == null || externalSheet.getWorkbookName() == null) {
            return this.getLocalNameXEval(nameXPxg);
        }
        String string = externalSheet.getWorkbookName();
        EvaluationWorkbook.ExternalName externalName = this._workbook.getExternalName(nameXPxg.getNameName(), nameXPxg.getSheetName(), nameXPxg.getExternalWorkbookNumber());
        return this.getExternalNameXEval(externalName, string);
    }

    private ValueEval getLocalNameXEval(NameXPxg nameXPxg) {
        String string;
        EvaluationName evaluationName;
        int n = -1;
        if (nameXPxg.getSheetName() != null) {
            n = this._workbook.getSheetIndex(nameXPxg.getSheetName());
        }
        if ((evaluationName = this._workbook.getName(string = nameXPxg.getNameName(), n)) != null) {
            return new ExternalNameEval(evaluationName);
        }
        return new FunctionNameEval(string);
    }

    private ValueEval getLocalNameXEval(NameXPtg nameXPtg) {
        String string = this._workbook.resolveNameXText(nameXPtg);
        int n = string.indexOf(33);
        EvaluationName evaluationName = null;
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            evaluationName = this._workbook.getName(string3, this._workbook.getSheetIndex(string2));
        } else {
            evaluationName = this._workbook.getName(string, -1);
        }
        if (evaluationName != null) {
            return new ExternalNameEval(evaluationName);
        }
        return new FunctionNameEval(string);
    }

    private ValueEval getExternalNameXEval(EvaluationWorkbook.ExternalName externalName, String string) {
        try {
            WorkbookEvaluator workbookEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(string);
            EvaluationName evaluationName = workbookEvaluator.getName(externalName.getName(), externalName.getIx() - 1);
            if (evaluationName != null && evaluationName.hasFormula()) {
                if (evaluationName.getNameDefinition().length > 1) {
                    throw new RuntimeException("Complex name formulas not supported yet");
                }
                OperationEvaluationContext operationEvaluationContext = new OperationEvaluationContext(workbookEvaluator, workbookEvaluator.getWorkbook(), -1, -1, -1, this._tracker);
                Ptg ptg = evaluationName.getNameDefinition()[0];
                if (ptg instanceof Ref3DPtg) {
                    Ref3DPtg ref3DPtg = (Ref3DPtg)ptg;
                    return operationEvaluationContext.getRef3DEval(ref3DPtg);
                }
                if (ptg instanceof Ref3DPxg) {
                    Ref3DPxg ref3DPxg = (Ref3DPxg)ptg;
                    return operationEvaluationContext.getRef3DEval(ref3DPxg);
                }
                if (ptg instanceof Area3DPtg) {
                    Area3DPtg area3DPtg = (Area3DPtg)ptg;
                    return operationEvaluationContext.getArea3DEval(area3DPtg);
                }
                if (ptg instanceof Area3DPxg) {
                    Area3DPxg area3DPxg = (Area3DPxg)ptg;
                    return operationEvaluationContext.getArea3DEval(area3DPxg);
                }
            }
            return ErrorEval.REF_INVALID;
        }
        catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException workbookNotFoundException) {
            return ErrorEval.REF_INVALID;
        }
    }
}

