/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.util.CellReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class FormulaUsedBlankCellSet {
    private final Map<BookSheetKey, BlankCellSheetGroup> _sheetGroupsByBookSheet = new HashMap<BookSheetKey, BlankCellSheetGroup>();

    public void addCell(int n, int n2, int n3, int n4) {
        BlankCellSheetGroup blankCellSheetGroup = this.getSheetGroup(n, n2);
        blankCellSheetGroup.addCell(n3, n4);
    }

    private BlankCellSheetGroup getSheetGroup(int n, int n2) {
        BookSheetKey bookSheetKey = new BookSheetKey(n, n2);
        BlankCellSheetGroup blankCellSheetGroup = this._sheetGroupsByBookSheet.get(bookSheetKey);
        if (blankCellSheetGroup == null) {
            blankCellSheetGroup = new BlankCellSheetGroup();
            this._sheetGroupsByBookSheet.put(bookSheetKey, blankCellSheetGroup);
        }
        return blankCellSheetGroup;
    }

    public boolean containsCell(BookSheetKey bookSheetKey, int n, int n2) {
        BlankCellSheetGroup blankCellSheetGroup = this._sheetGroupsByBookSheet.get(bookSheetKey);
        if (blankCellSheetGroup == null) {
            return false;
        }
        return blankCellSheetGroup.containsCell(n, n2);
    }

    public boolean isEmpty() {
        return this._sheetGroupsByBookSheet.isEmpty();
    }

    private static final class BlankCellRectangleGroup {
        private final int _firstRowIndex;
        private final int _firstColumnIndex;
        private final int _lastColumnIndex;
        private int _lastRowIndex;

        public BlankCellRectangleGroup(int n, int n2, int n3) {
            this._firstRowIndex = n;
            this._firstColumnIndex = n2;
            this._lastColumnIndex = n3;
            this._lastRowIndex = n;
        }

        public boolean containsCell(int n, int n2) {
            if (n2 < this._firstColumnIndex) {
                return false;
            }
            if (n2 > this._lastColumnIndex) {
                return false;
            }
            if (n < this._firstRowIndex) {
                return false;
            }
            return n <= this._lastRowIndex;
        }

        public boolean acceptRow(int n, int n2, int n3) {
            if (n2 != this._firstColumnIndex) {
                return false;
            }
            if (n3 != this._lastColumnIndex) {
                return false;
            }
            if (n != this._lastRowIndex + 1) {
                return false;
            }
            this._lastRowIndex = n;
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            CellReference cellReference = new CellReference(this._firstRowIndex, this._firstColumnIndex, false, false);
            CellReference cellReference2 = new CellReference(this._lastRowIndex, this._lastColumnIndex, false, false);
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" [").append(cellReference.formatAsString()).append(':').append(cellReference2.formatAsString()).append("]");
            return stringBuffer.toString();
        }
    }

    private static final class BlankCellSheetGroup {
        private final List<BlankCellRectangleGroup> _rectangleGroups = new ArrayList<BlankCellRectangleGroup>();
        private int _currentRowIndex = -1;
        private int _firstColumnIndex;
        private int _lastColumnIndex;
        private BlankCellRectangleGroup _currentRectangleGroup;

        public void addCell(int n, int n2) {
            if (this._currentRowIndex == -1) {
                this._currentRowIndex = n;
                this._firstColumnIndex = n2;
                this._lastColumnIndex = n2;
            } else if (this._currentRowIndex == n && this._lastColumnIndex + 1 == n2) {
                this._lastColumnIndex = n2;
            } else {
                if (this._currentRectangleGroup == null) {
                    this._currentRectangleGroup = new BlankCellRectangleGroup(this._currentRowIndex, this._firstColumnIndex, this._lastColumnIndex);
                } else if (!this._currentRectangleGroup.acceptRow(this._currentRowIndex, this._firstColumnIndex, this._lastColumnIndex)) {
                    this._rectangleGroups.add(this._currentRectangleGroup);
                    this._currentRectangleGroup = new BlankCellRectangleGroup(this._currentRowIndex, this._firstColumnIndex, this._lastColumnIndex);
                }
                this._currentRowIndex = n;
                this._firstColumnIndex = n2;
                this._lastColumnIndex = n2;
            }
        }

        public boolean containsCell(int n, int n2) {
            for (int i = this._rectangleGroups.size() - 1; i >= 0; --i) {
                BlankCellRectangleGroup blankCellRectangleGroup = this._rectangleGroups.get(i);
                if (!blankCellRectangleGroup.containsCell(n, n2)) continue;
                return true;
            }
            if (this._currentRectangleGroup != null && this._currentRectangleGroup.containsCell(n, n2)) {
                return true;
            }
            return this._currentRowIndex != -1 && this._currentRowIndex == n && this._firstColumnIndex <= n2 && n2 <= this._lastColumnIndex;
        }
    }

    public static final class BookSheetKey {
        private final int _bookIndex;
        private final int _sheetIndex;

        public BookSheetKey(int n, int n2) {
            this._bookIndex = n;
            this._sheetIndex = n2;
        }

        public int hashCode() {
            return this._bookIndex * 17 + this._sheetIndex;
        }

        public boolean equals(Object object) {
            assert (object instanceof BookSheetKey) : "these private cache key instances are only compared to themselves";
            BookSheetKey bookSheetKey = (BookSheetKey)object;
            return this._bookIndex == bookSheetKey._bookIndex && this._sheetIndex == bookSheetKey._sheetIndex;
        }
    }
}

