/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.FormulaCellCache;
import ai2.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import ai2.org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import ai2.org.apache.poi.ss.formula.IEvaluationListener;
import ai2.org.apache.poi.ss.formula.PlainCellCache;
import ai2.org.apache.poi.ss.formula.PlainValueCellCacheEntry;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai2.org.apache.poi.ss.formula.eval.BlankEval;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;

final class EvaluationCache {
    private final PlainCellCache _plainCellCache;
    private final FormulaCellCache _formulaCellCache;
    final IEvaluationListener _evaluationListener;

    EvaluationCache(IEvaluationListener iEvaluationListener) {
        this._evaluationListener = iEvaluationListener;
        this._plainCellCache = new PlainCellCache();
        this._formulaCellCache = new FormulaCellCache();
    }

    public void notifyUpdateCell(int n, int n2, EvaluationCell evaluationCell) {
        FormulaCellCacheEntry formulaCellCacheEntry = this._formulaCellCache.get(evaluationCell);
        int n3 = evaluationCell.getRowIndex();
        int n4 = evaluationCell.getColumnIndex();
        PlainCellCache.Loc loc = new PlainCellCache.Loc(n, n2, n3, n4);
        PlainValueCellCacheEntry plainValueCellCacheEntry = this._plainCellCache.get(loc);
        if (evaluationCell.getCellType() == 2) {
            if (formulaCellCacheEntry == null) {
                formulaCellCacheEntry = new FormulaCellCacheEntry();
                if (plainValueCellCacheEntry == null) {
                    if (this._evaluationListener != null) {
                        this._evaluationListener.onChangeFromBlankValue(n2, n3, n4, evaluationCell, formulaCellCacheEntry);
                    }
                    this.updateAnyBlankReferencingFormulas(n, n2, n3, n4);
                }
                this._formulaCellCache.put(evaluationCell, formulaCellCacheEntry);
            } else {
                formulaCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
                formulaCellCacheEntry.clearFormulaEntry();
            }
            if (plainValueCellCacheEntry != null) {
                plainValueCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
                this._plainCellCache.remove(loc);
            }
        } else {
            ValueEval valueEval = WorkbookEvaluator.getValueFromNonFormulaCell(evaluationCell);
            if (plainValueCellCacheEntry == null) {
                if (valueEval != BlankEval.instance) {
                    plainValueCellCacheEntry = new PlainValueCellCacheEntry(valueEval);
                    if (formulaCellCacheEntry == null) {
                        if (this._evaluationListener != null) {
                            this._evaluationListener.onChangeFromBlankValue(n2, n3, n4, evaluationCell, plainValueCellCacheEntry);
                        }
                        this.updateAnyBlankReferencingFormulas(n, n2, n3, n4);
                    }
                    this._plainCellCache.put(loc, plainValueCellCacheEntry);
                }
            } else {
                if (plainValueCellCacheEntry.updateValue(valueEval)) {
                    plainValueCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
                }
                if (valueEval == BlankEval.instance) {
                    this._plainCellCache.remove(loc);
                }
            }
            if (formulaCellCacheEntry != null) {
                this._formulaCellCache.remove(evaluationCell);
                formulaCellCacheEntry.setSensitiveInputCells(null);
                formulaCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        }
    }

    private void updateAnyBlankReferencingFormulas(int n, int n2, final int n3, final int n4) {
        final FormulaUsedBlankCellSet.BookSheetKey bookSheetKey = new FormulaUsedBlankCellSet.BookSheetKey(n, n2);
        this._formulaCellCache.applyOperation(new FormulaCellCache.IEntryOperation(){

            public void processEntry(FormulaCellCacheEntry formulaCellCacheEntry) {
                formulaCellCacheEntry.notifyUpdatedBlankCell(bookSheetKey, n3, n4, EvaluationCache.this._evaluationListener);
            }
        });
    }

    public PlainValueCellCacheEntry getPlainValueEntry(int n, int n2, int n3, int n4, ValueEval valueEval) {
        PlainCellCache.Loc loc = new PlainCellCache.Loc(n, n2, n3, n4);
        PlainValueCellCacheEntry plainValueCellCacheEntry = this._plainCellCache.get(loc);
        if (plainValueCellCacheEntry == null) {
            plainValueCellCacheEntry = new PlainValueCellCacheEntry(valueEval);
            this._plainCellCache.put(loc, plainValueCellCacheEntry);
            if (this._evaluationListener != null) {
                this._evaluationListener.onReadPlainValue(n2, n3, n4, plainValueCellCacheEntry);
            }
        } else {
            if (!this.areValuesEqual(plainValueCellCacheEntry.getValue(), valueEval)) {
                throw new IllegalStateException("value changed");
            }
            if (this._evaluationListener != null) {
                this._evaluationListener.onCacheHit(n2, n3, n4, valueEval);
            }
        }
        return plainValueCellCacheEntry;
    }

    private boolean areValuesEqual(ValueEval valueEval, ValueEval valueEval2) {
        if (valueEval == null) {
            return false;
        }
        Class<?> clazz = valueEval.getClass();
        if (clazz != valueEval2.getClass()) {
            return false;
        }
        if (valueEval == BlankEval.instance) {
            return valueEval2 == valueEval;
        }
        if (clazz == NumberEval.class) {
            return ((NumberEval)valueEval).getNumberValue() == ((NumberEval)valueEval2).getNumberValue();
        }
        if (clazz == StringEval.class) {
            return ((StringEval)valueEval).getStringValue().equals(((StringEval)valueEval2).getStringValue());
        }
        if (clazz == BoolEval.class) {
            return ((BoolEval)valueEval).getBooleanValue() == ((BoolEval)valueEval2).getBooleanValue();
        }
        if (clazz == ErrorEval.class) {
            return ((ErrorEval)valueEval).getErrorCode() == ((ErrorEval)valueEval2).getErrorCode();
        }
        throw new IllegalStateException("Unexpected value class (" + clazz.getName() + ")");
    }

    public FormulaCellCacheEntry getOrCreateFormulaCellEntry(EvaluationCell evaluationCell) {
        FormulaCellCacheEntry formulaCellCacheEntry = this._formulaCellCache.get(evaluationCell);
        if (formulaCellCacheEntry == null) {
            formulaCellCacheEntry = new FormulaCellCacheEntry();
            this._formulaCellCache.put(evaluationCell, formulaCellCacheEntry);
        }
        return formulaCellCacheEntry;
    }

    public void clear() {
        if (this._evaluationListener != null) {
            this._evaluationListener.onClearWholeCache();
        }
        this._plainCellCache.clear();
        this._formulaCellCache.clear();
    }

    public void notifyDeleteCell(int n, int n2, EvaluationCell evaluationCell) {
        if (evaluationCell.getCellType() == 2) {
            FormulaCellCacheEntry formulaCellCacheEntry = this._formulaCellCache.remove(evaluationCell);
            if (formulaCellCacheEntry != null) {
                formulaCellCacheEntry.setSensitiveInputCells(null);
                formulaCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        } else {
            PlainCellCache.Loc loc = new PlainCellCache.Loc(n, n2, evaluationCell.getRowIndex(), evaluationCell.getColumnIndex());
            PlainValueCellCacheEntry plainValueCellCacheEntry = this._plainCellCache.get(loc);
            if (plainValueCellCacheEntry != null) {
                plainValueCellCacheEntry.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        }
    }
}

