/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.format;

import ai2.org.apache.poi.ss.format.CellFormatPart;
import ai2.org.apache.poi.ss.format.CellFormatType;
import ai2.org.apache.poi.ss.format.CellFormatter;
import ai2.org.apache.poi.ss.format.CellTextFormatter;
import ai2.org.apache.poi.ss.format.SimpleFraction;
import ai2.org.apache.poi.util.LocaleUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellNumberFormatter
extends CellFormatter {
    private final String desc;
    private String printfFmt;
    private double scale = 1.0;
    private Special decimalPoint;
    private Special slash;
    private Special exponent;
    private Special numerator;
    private Special afterInteger;
    private Special afterFractional;
    private boolean integerCommas;
    private final List<Special> specials = new LinkedList<Special>();
    private List<Special> integerSpecials;
    private List<Special> fractionalSpecials;
    private List<Special> numeratorSpecials;
    private List<Special> denominatorSpecials;
    private List<Special> exponentSpecials;
    private List<Special> exponentDigitSpecials;
    private int maxDenominator;
    private String numeratorFmt;
    private String denominatorFmt;
    private boolean improperFraction;
    private DecimalFormat decimalFmt;
    static final CellFormatter SIMPLE_NUMBER = new CellFormatter("General"){

        public void formatValue(StringBuffer stringBuffer, Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                if (number.doubleValue() % 1.0 == 0.0) {
                    SIMPLE_INT.formatValue(stringBuffer, object);
                } else {
                    SIMPLE_FLOAT.formatValue(stringBuffer, object);
                }
            } else {
                CellTextFormatter.SIMPLE_TEXT.formatValue(stringBuffer, object);
            }
        }

        public void simpleValue(StringBuffer stringBuffer, Object object) {
            this.formatValue(stringBuffer, object);
        }
    };
    private static final CellFormatter SIMPLE_INT = new CellNumberFormatter("#");
    private static final CellFormatter SIMPLE_FLOAT = new CellNumberFormatter("#.#");

    public CellNumberFormatter(String string) {
        super(string);
        int n;
        NumPartHandler numPartHandler = new NumPartHandler();
        StringBuffer stringBuffer = CellFormatPart.parseFormat(string, CellFormatType.NUMBER, numPartHandler);
        if ((this.decimalPoint != null || this.exponent != null) && this.slash != null) {
            this.slash = null;
            this.numerator = null;
        }
        this.interpretCommas(stringBuffer);
        int n2 = 0;
        if (this.decimalPoint == null) {
            n = 0;
        } else {
            n = this.interpretPrecision();
            n2 = 1 + n;
            if (n == 0) {
                this.specials.remove(this.decimalPoint);
                this.decimalPoint = null;
            }
        }
        this.fractionalSpecials = n == 0 ? Collections.emptyList() : this.specials.subList(this.specials.indexOf(this.decimalPoint) + 1, this.fractionalEnd());
        if (this.exponent == null) {
            this.exponentSpecials = Collections.emptyList();
        } else {
            int n3 = this.specials.indexOf(this.exponent);
            this.exponentSpecials = this.specialsFor(n3, 2);
            this.exponentDigitSpecials = this.specialsFor(n3 + 2);
        }
        if (this.slash == null) {
            this.numeratorSpecials = Collections.emptyList();
            this.denominatorSpecials = Collections.emptyList();
        } else {
            this.numeratorSpecials = this.numerator == null ? Collections.emptyList() : this.specialsFor(this.specials.indexOf(this.numerator));
            this.denominatorSpecials = this.specialsFor(this.specials.indexOf(this.slash) + 1);
            if (this.denominatorSpecials.isEmpty()) {
                this.numeratorSpecials = Collections.emptyList();
            } else {
                this.maxDenominator = CellNumberFormatter.maxValue(this.denominatorSpecials);
                this.numeratorFmt = CellNumberFormatter.singleNumberFormat(this.numeratorSpecials);
                this.denominatorFmt = CellNumberFormatter.singleNumberFormat(this.denominatorSpecials);
            }
        }
        this.integerSpecials = this.specials.subList(0, this.integerEnd());
        if (this.exponent == null) {
            StringBuffer stringBuffer2 = new StringBuffer("%");
            int n4 = this.calculateIntegerPartWidth();
            int n5 = n4 + n2;
            stringBuffer2.append('0').append(n5).append('.').append(n);
            stringBuffer2.append("f");
            this.printfFmt = stringBuffer2.toString();
        } else {
            StringBuffer stringBuffer3 = new StringBuffer();
            boolean bl = true;
            List<Special> list = this.integerSpecials;
            if (this.integerSpecials.size() == 1) {
                stringBuffer3.append("0");
                bl = false;
            } else {
                for (Special special : list) {
                    if (!CellNumberFormatter.isDigitFmt(special)) continue;
                    stringBuffer3.append(bl ? (char)'#' : '0');
                    bl = false;
                }
            }
            if (this.fractionalSpecials.size() > 0) {
                stringBuffer3.append('.');
                for (Special special : this.fractionalSpecials) {
                    if (!CellNumberFormatter.isDigitFmt(special)) continue;
                    if (!bl) {
                        stringBuffer3.append('0');
                    }
                    bl = false;
                }
            }
            stringBuffer3.append('E');
            CellNumberFormatter.placeZeros(stringBuffer3, this.exponentSpecials.subList(2, this.exponentSpecials.size()));
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(LocaleUtil.getUserLocale());
            this.decimalFmt = new DecimalFormat(stringBuffer3.toString(), decimalFormatSymbols);
        }
        if (this.exponent != null) {
            this.scale = 1.0;
        }
        this.desc = stringBuffer.toString();
    }

    private static void placeZeros(StringBuffer stringBuffer, List<Special> list) {
        for (Special special : list) {
            if (!CellNumberFormatter.isDigitFmt(special)) continue;
            stringBuffer.append('0');
        }
    }

    private static Special firstDigit(List<Special> list) {
        for (Special special : list) {
            if (!CellNumberFormatter.isDigitFmt(special)) continue;
            return special;
        }
        return null;
    }

    static StringMod insertMod(Special special, CharSequence charSequence, int n) {
        return new StringMod(special, charSequence, n);
    }

    static StringMod deleteMod(Special special, boolean bl, Special special2, boolean bl2) {
        return new StringMod(special, bl, special2, bl2);
    }

    static StringMod replaceMod(Special special, boolean bl, Special special2, boolean bl2, char c) {
        return new StringMod(special, bl, special2, bl2, c);
    }

    private static String singleNumberFormat(List<Special> list) {
        return "%0" + list.size() + "d";
    }

    private static int maxValue(List<Special> list) {
        return (int)Math.round(Math.pow(10.0, list.size()) - 1.0);
    }

    private List<Special> specialsFor(int n, int n2) {
        Special special;
        if (n >= this.specials.size()) {
            return Collections.emptyList();
        }
        ListIterator<Special> listIterator = this.specials.listIterator(n + n2);
        Special special2 = listIterator.next();
        int n3 = n + n2;
        while (listIterator.hasNext() && CellNumberFormatter.isDigitFmt(special = listIterator.next()) && special.pos - special2.pos <= 1) {
            ++n3;
            special2 = special;
        }
        return this.specials.subList(n, n3 + 1);
    }

    private List<Special> specialsFor(int n) {
        return this.specialsFor(n, 0);
    }

    private static boolean isDigitFmt(Special special) {
        return special.ch == '0' || special.ch == '?' || special.ch == '#';
    }

    private Special previousNumber() {
        ListIterator<Special> listIterator = this.specials.listIterator(this.specials.size());
        while (listIterator.hasPrevious()) {
            Special special = listIterator.previous();
            if (!CellNumberFormatter.isDigitFmt(special)) continue;
            Special special2 = special;
            Special special3 = special;
            while (listIterator.hasPrevious()) {
                special = listIterator.previous();
                if (special3.pos - special.pos > 1 || !CellNumberFormatter.isDigitFmt(special)) break;
                special2 = special;
                special3 = special;
            }
            return special2;
        }
        return null;
    }

    private int calculateIntegerPartWidth() {
        Special special;
        ListIterator<Special> listIterator = this.specials.listIterator();
        int n = 0;
        while (listIterator.hasNext() && (special = listIterator.next()) != this.afterInteger) {
            if (!CellNumberFormatter.isDigitFmt(special)) continue;
            ++n;
        }
        return n;
    }

    private int interpretPrecision() {
        Special special;
        if (this.decimalPoint == null) {
            return -1;
        }
        int n = 0;
        ListIterator<Special> listIterator = this.specials.listIterator(this.specials.indexOf(this.decimalPoint));
        if (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasNext() && CellNumberFormatter.isDigitFmt(special = listIterator.next())) {
            ++n;
        }
        return n;
    }

    private void interpretCommas(StringBuffer stringBuffer) {
        Special special;
        ListIterator<Special> listIterator = this.specials.listIterator(this.integerEnd());
        boolean bl = true;
        this.integerCommas = false;
        while (listIterator.hasPrevious()) {
            special = listIterator.previous();
            if (special.ch != ',') {
                bl = false;
                continue;
            }
            if (bl) {
                this.scale /= 1000.0;
                continue;
            }
            this.integerCommas = true;
        }
        if (this.decimalPoint != null) {
            listIterator = this.specials.listIterator(this.fractionalEnd());
            while (listIterator.hasPrevious()) {
                special = listIterator.previous();
                if (special.ch != ',') break;
                this.scale /= 1000.0;
            }
        }
        listIterator = this.specials.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Special special2 = listIterator.next();
            special2.pos -= n;
            if (special2.ch != ',') continue;
            ++n;
            listIterator.remove();
            stringBuffer.deleteCharAt(special2.pos);
        }
    }

    private int integerEnd() {
        this.afterInteger = this.decimalPoint != null ? this.decimalPoint : (this.exponent != null ? this.exponent : (this.numerator != null ? this.numerator : null));
        return this.afterInteger == null ? this.specials.size() : this.specials.indexOf(this.afterInteger);
    }

    private int fractionalEnd() {
        if (this.exponent != null) {
            this.afterFractional = this.exponent;
        } else if (this.numerator != null) {
            this.afterInteger = this.numerator;
        } else {
            this.afterFractional = null;
        }
        int n = this.afterFractional == null ? this.specials.size() : this.specials.indexOf(this.afterFractional);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatValue(StringBuffer stringBuffer, Object object) {
        Object object2;
        Object object3;
        boolean bl;
        double d = ((Number)object).doubleValue();
        boolean bl2 = bl = (d *= this.scale) < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = 0.0;
        if (this.slash != null) {
            if (this.improperFraction) {
                d2 = d;
                d = 0.0;
            } else {
                d2 = d % 1.0;
                d = (long)d;
            }
        }
        TreeSet<StringMod> treeSet = new TreeSet<StringMod>();
        StringBuffer stringBuffer2 = new StringBuffer(this.desc);
        if (this.exponent != null) {
            this.writeScientific(d, stringBuffer2, treeSet);
        } else if (this.improperFraction) {
            this.writeFraction(d, null, d2, stringBuffer2, treeSet);
        } else {
            object3 = new StringBuffer();
            object2 = new Formatter((Appendable)object3, LocaleUtil.getUserLocale());
            try {
                ((Formatter)object2).format(LocaleUtil.getUserLocale(), this.printfFmt, d);
            }
            finally {
                ((Formatter)object2).close();
            }
            if (this.numerator == null) {
                this.writeFractional((StringBuffer)object3, stringBuffer2);
                this.writeInteger((StringBuffer)object3, stringBuffer2, this.integerSpecials, treeSet, this.integerCommas);
            } else {
                this.writeFraction(d, (StringBuffer)object3, d2, stringBuffer2, treeSet);
            }
        }
        object3 = this.specials.listIterator();
        object2 = treeSet.iterator();
        StringMod stringMod = object2.hasNext() ? (StringMod)object2.next() : null;
        int n = 0;
        BitSet bitSet = new BitSet();
        while (object3.hasNext()) {
            Special special = (Special)object3.next();
            int n2 = special.pos + n;
            if (!bitSet.get(special.pos) && stringBuffer2.charAt(n2) == '#') {
                stringBuffer2.deleteCharAt(n2);
                --n;
                bitSet.set(special.pos);
            }
            while (stringMod != null && special == stringMod.special) {
                int n3 = stringBuffer2.length();
                int n4 = special.pos + n;
                int n5 = 0;
                switch (stringMod.op) {
                    case 2: {
                        if (stringMod.toAdd.equals(",") && bitSet.get(special.pos)) break;
                        n5 = 1;
                    }
                    case 1: {
                        stringBuffer2.insert(n4 + n5, stringMod.toAdd);
                        break;
                    }
                    case 3: {
                        int n6;
                        int n7 = special.pos;
                        if (!stringMod.startInclusive) {
                            ++n7;
                            ++n4;
                        }
                        while (bitSet.get(n7)) {
                            ++n7;
                            ++n4;
                        }
                        int n8 = stringMod.end.pos;
                        if (stringMod.endInclusive) {
                            ++n8;
                        }
                        if (n4 >= (n6 = n8 + n)) break;
                        if ("".equals(stringMod.toAdd)) {
                            stringBuffer2.delete(n4, n6);
                        } else {
                            char c = stringMod.toAdd.charAt(0);
                            for (int i = n4; i < n6; ++i) {
                                stringBuffer2.setCharAt(i, c);
                            }
                        }
                        bitSet.set(n7, n8);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown op: " + stringMod.op);
                    }
                }
                n += stringBuffer2.length() - n3;
                if (object2.hasNext()) {
                    stringMod = (StringMod)object2.next();
                    continue;
                }
                stringMod = null;
            }
        }
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append(stringBuffer2);
    }

    private void writeScientific(double d, StringBuffer stringBuffer, Set<StringMod> set) {
        StringBuffer stringBuffer2 = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        this.decimalFmt.format(d, stringBuffer2, fieldPosition);
        this.writeInteger(stringBuffer2, stringBuffer, this.integerSpecials, set, this.integerCommas);
        this.writeFractional(stringBuffer2, stringBuffer);
        int n = fieldPosition.getEndIndex();
        int n2 = n + 1;
        char c = stringBuffer2.charAt(n2);
        if (c != '-') {
            c = '+';
            stringBuffer2.insert(n2, '+');
        }
        ListIterator<Special> listIterator = this.exponentSpecials.listIterator(1);
        Special special = listIterator.next();
        char c2 = special.ch;
        if (c == '-' || c2 == '+') {
            set.add(CellNumberFormatter.replaceMod(special, true, special, true, c));
        } else {
            set.add(CellNumberFormatter.deleteMod(special, true, special, true));
        }
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer2.substring(n2 + 1));
        this.writeInteger(stringBuffer3, stringBuffer, this.exponentDigitSpecials, set, false);
    }

    private void writeFraction(double d, StringBuffer stringBuffer, double d2, StringBuffer stringBuffer2, Set<StringMod> set) {
        int n;
        int n2;
        if (!this.improperFraction) {
            boolean bl;
            if (d2 == 0.0 && !CellNumberFormatter.hasChar('0', this.numeratorSpecials)) {
                this.writeInteger(stringBuffer, stringBuffer2, this.integerSpecials, set, false);
                Special special = this.integerSpecials.get(this.integerSpecials.size() - 1);
                Special special2 = this.denominatorSpecials.get(this.denominatorSpecials.size() - 1);
                if (CellNumberFormatter.hasChar('?', this.integerSpecials, this.numeratorSpecials, this.denominatorSpecials)) {
                    set.add(CellNumberFormatter.replaceMod(special, false, special2, true, ' '));
                } else {
                    set.add(CellNumberFormatter.deleteMod(special, false, special2, true));
                }
                return;
            }
            n2 = d == 0.0 && d2 == 0.0 ? 1 : 0;
            n = d2 != 0.0 || CellNumberFormatter.hasChar('0', this.numeratorSpecials) ? 1 : 0;
            boolean bl2 = n2 != 0 && (CellNumberFormatter.hasOnly('#', this.integerSpecials) || !CellNumberFormatter.hasChar('0', this.numeratorSpecials));
            boolean bl3 = bl = n2 == 0 && d == 0.0 && n != 0 && !CellNumberFormatter.hasChar('0', this.integerSpecials);
            if (bl2 || bl) {
                Special special = this.integerSpecials.get(this.integerSpecials.size() - 1);
                if (CellNumberFormatter.hasChar('?', this.integerSpecials, this.numeratorSpecials)) {
                    set.add(CellNumberFormatter.replaceMod(special, true, this.numerator, false, ' '));
                } else {
                    set.add(CellNumberFormatter.deleteMod(special, true, this.numerator, false));
                }
            } else {
                this.writeInteger(stringBuffer, stringBuffer2, this.integerSpecials, set, false);
            }
        }
        try {
            if (d2 == 0.0 || this.improperFraction && d2 % 1.0 == 0.0) {
                n2 = (int)Math.round(d2);
                n = 1;
            } else {
                SimpleFraction simpleFraction = SimpleFraction.buildFractionMaxDenominator(d2, this.maxDenominator);
                n2 = simpleFraction.getNumerator();
                n = simpleFraction.getDenominator();
            }
            if (this.improperFraction) {
                n2 = (int)((long)n2 + Math.round(d * (double)n));
            }
            this.writeSingleInteger(this.numeratorFmt, n2, stringBuffer2, this.numeratorSpecials, set);
            this.writeSingleInteger(this.denominatorFmt, n, stringBuffer2, this.denominatorSpecials, set);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private static boolean hasChar(char c, List<Special> ... listArray) {
        for (List<Special> list : listArray) {
            for (Special special : list) {
                if (special.ch != c) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasOnly(char c, List<Special> ... listArray) {
        for (List<Special> list : listArray) {
            for (Special special : list) {
                if (special.ch == c) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSingleInteger(String string, int n, StringBuffer stringBuffer, List<Special> list, Set<StringMod> set) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Formatter formatter = new Formatter(stringBuffer2, LocaleUtil.getUserLocale());
        try {
            formatter.format(LocaleUtil.getUserLocale(), string, n);
        }
        finally {
            formatter.close();
        }
        this.writeInteger(stringBuffer2, stringBuffer, list, set, false);
    }

    private void writeInteger(StringBuffer stringBuffer, StringBuffer stringBuffer2, List<Special> list, Set<StringMod> set, boolean bl) {
        char c;
        int n;
        int n2 = stringBuffer.indexOf(".") - 1;
        if (n2 < 0) {
            n2 = this.exponent != null && list == this.integerSpecials ? stringBuffer.indexOf("E") - 1 : stringBuffer.length() - 1;
        }
        for (n = 0; n < n2 && ((c = stringBuffer.charAt(n)) == '0' || c == ','); ++n) {
        }
        ListIterator<Special> listIterator = list.listIterator(list.size());
        boolean bl2 = false;
        Special special = null;
        int n3 = 0;
        while (listIterator.hasPrevious()) {
            char c2 = n2 >= 0 ? (char)stringBuffer.charAt(n2) : (char)'0';
            Special special2 = listIterator.previous();
            bl2 = bl && n3 > 0 && n3 % 3 == 0;
            boolean bl3 = false;
            if (c2 != '0' || special2.ch == '0' || special2.ch == '?' || n2 >= n) {
                bl3 = special2.ch == '?' && n2 < n;
                stringBuffer2.setCharAt(special2.pos, bl3 ? (char)' ' : c2);
                special = special2;
            }
            if (bl2) {
                set.add(CellNumberFormatter.insertMod(special2, bl3 ? " " : ",", 2));
                bl2 = false;
            }
            ++n3;
            --n2;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        if (n2 >= 0) {
            stringBuffer3 = new StringBuffer(stringBuffer.substring(0, ++n2));
            if (bl) {
                while (n2 > 0) {
                    if (n3 > 0 && n3 % 3 == 0) {
                        stringBuffer3.insert(n2, ',');
                    }
                    ++n3;
                    --n2;
                }
            }
            set.add(CellNumberFormatter.insertMod(special, stringBuffer3, 1));
        }
    }

    private void writeFractional(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (this.fractionalSpecials.size() > 0) {
            int n;
            int n2 = stringBuffer.indexOf(".") + 1;
            for (n = this.exponent != null ? stringBuffer.indexOf("e") - 1 : stringBuffer.length() - 1; n > n2 && stringBuffer.charAt(n) == '0'; --n) {
            }
            ListIterator<Special> listIterator = this.fractionalSpecials.listIterator();
            while (listIterator.hasNext()) {
                Special special = listIterator.next();
                char c = stringBuffer.charAt(n2);
                if (c != '0' || special.ch == '0' || n2 < n) {
                    stringBuffer2.setCharAt(special.pos, c);
                } else if (special.ch == '?') {
                    stringBuffer2.setCharAt(special.pos, ' ');
                }
                ++n2;
            }
        }
    }

    @Override
    public void simpleValue(StringBuffer stringBuffer, Object object) {
        SIMPLE_NUMBER.formatValue(stringBuffer, object);
    }

    private class NumPartHandler
    implements CellFormatPart.PartHandler {
        private char insertSignForExponent;

        private NumPartHandler() {
        }

        public String handlePart(Matcher matcher, String string, CellFormatType cellFormatType, StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            char c = string.charAt(0);
            switch (c) {
                case 'E': 
                case 'e': {
                    if (CellNumberFormatter.this.exponent != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    CellNumberFormatter.this.specials.add(CellNumberFormatter.this.exponent = new Special('.', n));
                    this.insertSignForExponent = string.charAt(1);
                    return string.substring(0, 1);
                }
                case '#': 
                case '0': 
                case '?': {
                    if (this.insertSignForExponent != '\u0000') {
                        CellNumberFormatter.this.specials.add(new Special(this.insertSignForExponent, n));
                        stringBuffer.append(this.insertSignForExponent);
                        this.insertSignForExponent = '\u0000';
                        ++n;
                    }
                    for (int i = 0; i < string.length(); ++i) {
                        char c2 = string.charAt(i);
                        CellNumberFormatter.this.specials.add(new Special(c2, n + i));
                    }
                    break;
                }
                case '.': {
                    if (CellNumberFormatter.this.decimalPoint != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    CellNumberFormatter.this.specials.add(CellNumberFormatter.this.decimalPoint = new Special('.', n));
                    break;
                }
                case '/': {
                    if (CellNumberFormatter.this.slash != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    CellNumberFormatter.this.numerator = CellNumberFormatter.this.previousNumber();
                    if (CellNumberFormatter.this.numerator == CellNumberFormatter.firstDigit(CellNumberFormatter.this.specials)) {
                        CellNumberFormatter.this.improperFraction = true;
                    }
                    CellNumberFormatter.this.specials.add(CellNumberFormatter.this.slash = new Special('.', n));
                    break;
                }
                case '%': {
                    CellNumberFormatter.this.scale *= 100.0;
                    break;
                }
                default: {
                    return null;
                }
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringMod
    implements Comparable<StringMod> {
        final Special special;
        final int op;
        CharSequence toAdd;
        Special end;
        boolean startInclusive;
        boolean endInclusive;
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public static final int REPLACE = 3;

        private StringMod(Special special, CharSequence charSequence, int n) {
            this.special = special;
            this.toAdd = charSequence;
            this.op = n;
        }

        public StringMod(Special special, boolean bl, Special special2, boolean bl2, char c) {
            this(special, bl, special2, bl2);
            this.toAdd = c + "";
        }

        public StringMod(Special special, boolean bl, Special special2, boolean bl2) {
            this.special = special;
            this.startInclusive = bl;
            this.end = special2;
            this.endInclusive = bl2;
            this.op = 3;
            this.toAdd = "";
        }

        @Override
        public int compareTo(StringMod stringMod) {
            int n = this.special.pos - stringMod.special.pos;
            if (n != 0) {
                return n;
            }
            return this.op - stringMod.op;
        }

        public boolean equals(Object object) {
            try {
                return this.compareTo((StringMod)object) == 0;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public int hashCode() {
            return this.special.hashCode() + this.op;
        }
    }

    static class Special {
        final char ch;
        int pos;

        Special(char c, int n) {
            this.ch = c;
            this.pos = n;
        }

        public String toString() {
            return "'" + this.ch + "' @ " + this.pos;
        }
    }
}

