/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.format;

import ai2.org.apache.poi.ss.format.CellFormatPart;
import ai2.org.apache.poi.ss.format.CellFormatResult;
import ai2.org.apache.poi.ss.format.CellFormatType;
import ai2.org.apache.poi.ss.format.CellFormatter;
import ai2.org.apache.poi.ss.format.CellGeneralFormatter;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;

public class CellFormat {
    private final String format;
    private final CellFormatPart posNumFmt;
    private final CellFormatPart zeroNumFmt;
    private final CellFormatPart negNumFmt;
    private final CellFormatPart textFmt;
    private final int formatPartCount;
    private static final Pattern ONE_PART = Pattern.compile(CellFormatPart.FORMAT_PAT.pattern() + "(;|$)", 6);
    private static final CellFormatPart DEFAULT_TEXT_FORMAT = new CellFormatPart("@");
    private static final String INVALID_VALUE_FOR_FORMAT = "###############################################################################################################################################################################################################################################################";
    private static String QUOTE = "\"";
    public static final CellFormat GENERAL_FORMAT = new CellFormat("General"){

        public CellFormatResult apply(Object object) {
            String string = new CellGeneralFormatter().format(object);
            return new CellFormatResult(true, string, null);
        }
    };
    private static final Map<String, CellFormat> formatCache = new WeakHashMap<String, CellFormat>();

    public static CellFormat getInstance(String string) {
        CellFormat cellFormat = formatCache.get(string);
        if (cellFormat == null) {
            cellFormat = string.equals("General") || string.equals("@") ? GENERAL_FORMAT : new CellFormat(string);
            formatCache.put(string, cellFormat);
        }
        return cellFormat;
    }

    private CellFormat(String string) {
        this.format = string;
        Matcher matcher = ONE_PART.matcher(string);
        ArrayList<CellFormatPart> arrayList = new ArrayList<CellFormatPart>();
        while (matcher.find()) {
            try {
                String string2 = matcher.group();
                if (string2.endsWith(";")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                arrayList.add(new CellFormatPart(string2));
            }
            catch (RuntimeException runtimeException) {
                CellFormatter.logger.log(Level.WARNING, "Invalid format: " + CellFormatter.quote(matcher.group()), runtimeException);
                arrayList.add(null);
            }
        }
        this.formatPartCount = arrayList.size();
        switch (this.formatPartCount) {
            case 1: {
                this.posNumFmt = (CellFormatPart)arrayList.get(0);
                this.negNumFmt = null;
                this.zeroNumFmt = null;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 2: {
                this.posNumFmt = (CellFormatPart)arrayList.get(0);
                this.negNumFmt = (CellFormatPart)arrayList.get(1);
                this.zeroNumFmt = null;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 3: {
                this.posNumFmt = (CellFormatPart)arrayList.get(0);
                this.negNumFmt = (CellFormatPart)arrayList.get(1);
                this.zeroNumFmt = (CellFormatPart)arrayList.get(2);
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            default: {
                this.posNumFmt = (CellFormatPart)arrayList.get(0);
                this.negNumFmt = (CellFormatPart)arrayList.get(1);
                this.zeroNumFmt = (CellFormatPart)arrayList.get(2);
                this.textFmt = (CellFormatPart)arrayList.get(3);
            }
        }
    }

    public CellFormatResult apply(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < 0.0 && (this.formatPartCount == 2 && !this.posNumFmt.hasCondition() && !this.negNumFmt.hasCondition() || this.formatPartCount == 3 && !this.negNumFmt.hasCondition() || this.formatPartCount == 4 && !this.negNumFmt.hasCondition())) {
                return this.negNumFmt.apply(-d);
            }
            return this.getApplicableFormatPart(d).apply(d);
        }
        if (object instanceof Date) {
            Double d = DateUtil.getExcelDate((Date)object);
            if (DateUtil.isValidExcelDate(d)) {
                return this.getApplicableFormatPart(d).apply(object);
            }
            throw new IllegalArgumentException("value not a valid Excel date");
        }
        return this.textFmt.apply(object);
    }

    private CellFormatResult apply(Date date, double d) {
        return this.getApplicableFormatPart(d).apply(date);
    }

    public CellFormatResult apply(Cell cell) {
        switch (CellFormat.ultimateType(cell)) {
            case 3: {
                return this.apply("");
            }
            case 4: {
                return this.apply(cell.getBooleanCellValue());
            }
            case 0: {
                Double d = cell.getNumericCellValue();
                if (this.getApplicableFormatPart(d).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(d)) {
                        return this.apply(cell.getDateCellValue(), d);
                    }
                    return this.apply(INVALID_VALUE_FOR_FORMAT);
                }
                return this.apply(d);
            }
            case 1: {
                return this.apply(cell.getStringCellValue());
            }
        }
        return this.apply("?");
    }

    public CellFormatResult apply(JLabel jLabel, Object object) {
        CellFormatResult cellFormatResult = this.apply(object);
        jLabel.setText(cellFormatResult.text);
        if (cellFormatResult.textColor != null) {
            jLabel.setForeground(cellFormatResult.textColor);
        }
        return cellFormatResult;
    }

    private CellFormatResult apply(JLabel jLabel, Date date, double d) {
        CellFormatResult cellFormatResult = this.apply(date, d);
        jLabel.setText(cellFormatResult.text);
        if (cellFormatResult.textColor != null) {
            jLabel.setForeground(cellFormatResult.textColor);
        }
        return cellFormatResult;
    }

    public CellFormatResult apply(JLabel jLabel, Cell cell) {
        switch (CellFormat.ultimateType(cell)) {
            case 3: {
                return this.apply(jLabel, "");
            }
            case 4: {
                return this.apply(jLabel, cell.getBooleanCellValue());
            }
            case 0: {
                Double d = cell.getNumericCellValue();
                if (this.getApplicableFormatPart(d).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(d)) {
                        return this.apply(jLabel, cell.getDateCellValue(), d);
                    }
                    return this.apply(jLabel, INVALID_VALUE_FOR_FORMAT);
                }
                return this.apply(jLabel, d);
            }
            case 1: {
                return this.apply(jLabel, cell.getStringCellValue());
            }
        }
        return this.apply(jLabel, "?");
    }

    private CellFormatPart getApplicableFormatPart(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (this.formatPartCount == 1) {
                if (!this.posNumFmt.hasCondition() || this.posNumFmt.hasCondition() && this.posNumFmt.applies(d)) {
                    return this.posNumFmt;
                }
                return new CellFormatPart("General");
            }
            if (this.formatPartCount == 2) {
                if (!this.posNumFmt.hasCondition() && d >= 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(d)) {
                    return this.posNumFmt;
                }
                if (!this.negNumFmt.hasCondition() || this.negNumFmt.hasCondition() && this.negNumFmt.applies(d)) {
                    return this.negNumFmt;
                }
                return new CellFormatPart(QUOTE + INVALID_VALUE_FOR_FORMAT + QUOTE);
            }
            if (!this.posNumFmt.hasCondition() && d > 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(d)) {
                return this.posNumFmt;
            }
            if (!this.negNumFmt.hasCondition() && d < 0.0 || this.negNumFmt.hasCondition() && this.negNumFmt.applies(d)) {
                return this.negNumFmt;
            }
            return this.zeroNumFmt;
        }
        throw new IllegalArgumentException("value must be a Number");
    }

    public static int ultimateType(Cell cell) {
        int n = cell.getCellType();
        if (n == 2) {
            return cell.getCachedFormulaResultType();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CellFormat) {
            CellFormat cellFormat = (CellFormat)object;
            return this.format.equals(cellFormat.format);
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

