/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.format;

import ai2.org.apache.poi.ss.format.CellFormatPart;
import ai2.org.apache.poi.ss.format.CellFormatType;
import ai2.org.apache.poi.ss.format.CellFormatter;
import ai2.org.apache.poi.util.LocaleUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;

public class CellDateFormatter
extends CellFormatter {
    private boolean amPmUpper;
    private boolean showM;
    private boolean showAmPm;
    private final DateFormat dateFmt;
    private String sFmt;
    private final Calendar EXCEL_EPOCH_CAL = LocaleUtil.getLocaleCalendar(1904, 0, 1);
    private static CellDateFormatter SIMPLE_DATE = null;

    public CellDateFormatter(String string) {
        super(string);
        DatePartHandler datePartHandler = new DatePartHandler();
        StringBuffer stringBuffer = CellFormatPart.parseFormat(string, CellFormatType.DATE, datePartHandler);
        datePartHandler.finish(stringBuffer);
        String string2 = stringBuffer.toString().replaceAll("((y)(?!y))(?<!yy)", "yy");
        this.dateFmt = new SimpleDateFormat(string2, LocaleUtil.getUserLocale());
        this.dateFmt.setTimeZone(LocaleUtil.getUserTimeZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatValue(StringBuffer stringBuffer, Object object) {
        Object object2;
        if (object == null) {
            object = 0.0;
        }
        if (object instanceof Number) {
            object2 = (Number)object;
            long l = ((Number)object2).longValue();
            if (l == 0L) {
                object = this.EXCEL_EPOCH_CAL.getTime();
            } else {
                Calendar calendar = (Calendar)this.EXCEL_EPOCH_CAL.clone();
                calendar.add(13, (int)(l / 1000L));
                calendar.add(14, (int)(l % 1000L));
                object = calendar.getTime();
            }
        }
        object2 = this.dateFmt.formatToCharacterIterator(object);
        boolean bl = false;
        boolean bl2 = false;
        object2.first();
        char c = object2.first();
        while (c != '\uffff') {
            if (object2.getAttribute(DateFormat.Field.MILLISECOND) != null) {
                if (!bl2) {
                    Date date = (Date)object;
                    int n = stringBuffer.length();
                    Formatter formatter = new Formatter(stringBuffer, Locale.ROOT);
                    try {
                        long l = date.getTime() % 1000L;
                        formatter.format(LocaleUtil.getUserLocale(), this.sFmt, (double)l / 1000.0);
                    }
                    finally {
                        formatter.close();
                    }
                    stringBuffer.delete(n, n + 2);
                    bl2 = true;
                }
            } else if (object2.getAttribute(DateFormat.Field.AM_PM) != null) {
                if (!bl) {
                    if (this.showAmPm) {
                        if (this.amPmUpper) {
                            stringBuffer.append(Character.toUpperCase(c));
                            if (this.showM) {
                                stringBuffer.append('M');
                            }
                        } else {
                            stringBuffer.append(Character.toLowerCase(c));
                            if (this.showM) {
                                stringBuffer.append('m');
                            }
                        }
                    }
                    bl = true;
                }
            } else {
                stringBuffer.append(c);
            }
            c = object2.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleValue(StringBuffer stringBuffer, Object object) {
        Class<CellDateFormatter> clazz = CellDateFormatter.class;
        synchronized (CellDateFormatter.class) {
            if (SIMPLE_DATE == null || !CellDateFormatter.SIMPLE_DATE.EXCEL_EPOCH_CAL.equals(this.EXCEL_EPOCH_CAL)) {
                SIMPLE_DATE = new CellDateFormatter("mm/d/y");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            SIMPLE_DATE.formatValue(stringBuffer, object);
            return;
        }
    }

    private class DatePartHandler
    implements CellFormatPart.PartHandler {
        private int mStart = -1;
        private int mLen;
        private int hStart = -1;
        private int hLen;

        private DatePartHandler() {
        }

        public String handlePart(Matcher matcher, String string, CellFormatType cellFormatType, StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            char c = string.charAt(0);
            switch (c) {
                case 'S': 
                case 's': {
                    if (this.mStart >= 0) {
                        for (int i = 0; i < this.mLen; ++i) {
                            stringBuffer.setCharAt(this.mStart + i, 'm');
                        }
                        this.mStart = -1;
                    }
                    return string.toLowerCase(Locale.ROOT);
                }
                case 'H': 
                case 'h': {
                    this.mStart = -1;
                    this.hStart = n;
                    this.hLen = string.length();
                    return string.toLowerCase(Locale.ROOT);
                }
                case 'D': 
                case 'd': {
                    this.mStart = -1;
                    if (string.length() <= 2) {
                        return string.toLowerCase(Locale.ROOT);
                    }
                    return string.toLowerCase(Locale.ROOT).replace('d', 'E');
                }
                case 'M': 
                case 'm': {
                    this.mStart = n;
                    this.mLen = string.length();
                    if (this.hStart >= 0) {
                        return string.toLowerCase(Locale.ROOT);
                    }
                    return string.toUpperCase(Locale.ROOT);
                }
                case 'Y': 
                case 'y': {
                    this.mStart = -1;
                    if (string.length() == 3) {
                        string = "yyyy";
                    }
                    return string.toLowerCase(Locale.ROOT);
                }
                case '0': {
                    this.mStart = -1;
                    int n2 = string.length();
                    CellDateFormatter.this.sFmt = "%0" + (n2 + 2) + "." + n2 + "f";
                    return string.replace('0', 'S');
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    if (string.length() <= 1) break;
                    this.mStart = -1;
                    CellDateFormatter.this.showAmPm = true;
                    CellDateFormatter.this.showM = Character.toLowerCase(string.charAt(1)) == 'm';
                    CellDateFormatter.this.amPmUpper = CellDateFormatter.this.showM || Character.isUpperCase(string.charAt(0));
                    return "a";
                }
            }
            return null;
        }

        public void finish(StringBuffer stringBuffer) {
            if (this.hStart >= 0 && !CellDateFormatter.this.showAmPm) {
                for (int i = 0; i < this.hLen; ++i) {
                    stringBuffer.setCharAt(this.hStart + i, 'H');
                }
            }
        }
    }
}

