/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss;

import ai2.org.apache.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SpreadsheetVersion {
    EXCEL97(65536, 256, 30, 3, 4000, Short.MAX_VALUE),
    EXCEL2007(0x100000, 16384, 255, Integer.MAX_VALUE, 64000, Short.MAX_VALUE);

    private final int _maxRows;
    private final int _maxColumns;
    private final int _maxFunctionArgs;
    private final int _maxCondFormats;
    private final int _maxCellStyles;
    private final int _maxTextLength;

    private SpreadsheetVersion(int n2, int n3, int n4, int n5, int n6, int n7) {
        this._maxRows = n2;
        this._maxColumns = n3;
        this._maxFunctionArgs = n4;
        this._maxCondFormats = n5;
        this._maxCellStyles = n6;
        this._maxTextLength = n7;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public int getLastRowIndex() {
        return this._maxRows - 1;
    }

    public int getMaxColumns() {
        return this._maxColumns;
    }

    public int getLastColumnIndex() {
        return this._maxColumns - 1;
    }

    public int getMaxFunctionArgs() {
        return this._maxFunctionArgs;
    }

    public int getMaxConditionalFormats() {
        return this._maxCondFormats;
    }

    public int getMaxCellStyles() {
        return this._maxCellStyles;
    }

    public String getLastColumnName() {
        return CellReference.convertNumToColString(this.getLastColumnIndex());
    }

    public int getMaxTextLength() {
        return this._maxTextLength;
    }
}

