/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.usermodel;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import ai2.org.apache.poi.sl.usermodel.SlideShow;
import ai2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShowFactory {
    private static final byte[] OOXML_FILE_HEADER = new byte[]{80, 75, 3, 4};

    public static SlideShow<?, ?> create(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        return SlideShowFactory.create(nPOIFSFileSystem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlideShow<?, ?> create(NPOIFSFileSystem nPOIFSFileSystem, String string) throws IOException {
        DirectoryNode directoryNode = nPOIFSFileSystem.getRoot();
        if (directoryNode.hasEntry("EncryptedPackage")) {
            EncryptionInfo encryptionInfo = new EncryptionInfo(nPOIFSFileSystem);
            Decryptor decryptor = Decryptor.getInstance(encryptionInfo);
            boolean bl = false;
            InputStream inputStream = null;
            try {
                if (string != null && decryptor.verifyPassword(string)) {
                    bl = true;
                }
                if (!bl && decryptor.verifyPassword("VelvetSweatshop")) {
                    bl = true;
                }
                if (bl) {
                    inputStream = decryptor.getDataStream(directoryNode);
                }
                if (!bl) {
                    String string2 = string != null ? "Password incorrect" : "The supplied spreadsheet is protected, but no password was supplied";
                    throw new EncryptedDocumentException(string2);
                }
                SlideShow<?, ?> slideShow = SlideShowFactory.createXSLFSlideShow(inputStream);
                return slideShow;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (string != null) {
            Biff8EncryptionKey.setCurrentUserPassword(string);
        }
        try {
            SlideShow<?, ?> slideShow = SlideShowFactory.createHSLFSlideShow(nPOIFSFileSystem);
            return slideShow;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static SlideShow<?, ?> create(InputStream inputStream) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(inputStream, null);
    }

    public static SlideShow<?, ?> create(InputStream inputStream, String string) throws IOException, EncryptedDocumentException {
        byte[] byArray;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(byArray = IOUtils.peekFirst8Bytes(inputStream))) {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(inputStream);
            return SlideShowFactory.create(nPOIFSFileSystem, string);
        }
        if (SlideShowFactory.hasOOXMLHeader(inputStream)) {
            return SlideShowFactory.createXSLFSlideShow(inputStream);
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static SlideShow<?, ?> create(File file) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, null);
    }

    public static SlideShow<?, ?> create(File file, String string) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, string, false);
    }

    public static SlideShow<?, ?> create(File file, String string, boolean bl) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(file, bl);
            return SlideShowFactory.create(nPOIFSFileSystem, string);
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            return SlideShowFactory.createXSLFSlideShow(file, bl);
        }
    }

    protected static SlideShow<?, ?> createHSLFSlideShow(Object ... objectArray) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowFactory", objectArray);
    }

    protected static SlideShow<?, ?> createXSLFSlideShow(Object ... objectArray) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("ai2.org.apache.poi.xslf.usermodel.XSLFSlideShowFactory", objectArray);
    }

    protected static SlideShow<?, ?> createSlideShow(String string, Object[] objectArray) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            Class[] classArray = new Class[objectArray.length];
            int n = 0;
            for (Object object : objectArray) {
                Class<Object> clazz2 = object.getClass();
                if (Boolean.class.isAssignableFrom(clazz2)) {
                    clazz2 = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(clazz2)) {
                    clazz2 = InputStream.class;
                }
                classArray[n++] = clazz2;
            }
            Method method = clazz.getMethod("createSlideShow", classArray);
            return (SlideShow)method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)throwable;
            }
            throw new IOException(throwable);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    protected static boolean hasOOXMLHeader(InputStream inputStream) throws IOException {
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n = IOUtils.readFully(inputStream, byArray);
        if (inputStream instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
            pushbackInputStream.unread(byArray, 0, n);
        } else {
            inputStream.reset();
        }
        return n == 4 && byArray[0] == OOXML_FILE_HEADER[0] && byArray[1] == OOXML_FILE_HEADER[1] && byArray[2] == OOXML_FILE_HEADER[2] && byArray[3] == OOXML_FILE_HEADER[3];
    }
}

