/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw.geom;

import ai2.org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import ai2.org.apache.poi.sl.draw.geom.CustomGeometry;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetGeometries
extends LinkedHashMap<String, CustomGeometry> {
    private static final POILogger LOG = POILogFactory.getLogger(PresetGeometries.class);
    protected static final String BINDING_PACKAGE = "ai2.org.apache.poi.sl.draw.binding";
    protected static PresetGeometries _inst;

    protected PresetGeometries() {
    }

    public void init(InputStream inputStream) throws XMLStreamException, JAXBException {
        EventFilter eventFilter = new EventFilter(){

            public boolean accept(XMLEvent xMLEvent) {
                return xMLEvent.isStartElement();
            }
        };
        XMLInputFactory xMLInputFactory = XMLInputFactory.newFactory();
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStream);
        XMLEventReader xMLEventReader2 = xMLInputFactory.createFilteredReader(xMLEventReader, eventFilter);
        xMLEventReader2.nextEvent();
        JAXBContext jAXBContext = JAXBContext.newInstance((String)BINDING_PACKAGE);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        long l = 0L;
        while (xMLEventReader2.peek() != null) {
            StartElement startElement = (StartElement)xMLEventReader2.peek();
            String string = startElement.getName().getLocalPart();
            JAXBElement jAXBElement = unmarshaller.unmarshal(xMLEventReader, CTCustomGeometry2D.class);
            CTCustomGeometry2D cTCustomGeometry2D = (CTCustomGeometry2D)jAXBElement.getValue();
            ++l;
            if (this.containsKey(string)) {
                LOG.log(5, new Object[]{"Duplicate definition of " + string});
            }
            this.put(string, new CustomGeometry(cTCustomGeometry2D));
        }
    }

    public static CustomGeometry convertCustomGeometry(XMLStreamReader xMLStreamReader) {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)BINDING_PACKAGE);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            JAXBElement jAXBElement = unmarshaller.unmarshal(xMLStreamReader, CTCustomGeometry2D.class);
            return new CustomGeometry((CTCustomGeometry2D)jAXBElement.getValue());
        }
        catch (JAXBException jAXBException) {
            LOG.log(7, new Object[]{"Unable to parse single custom geometry", jAXBException});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PresetGeometries getInstance() {
        if (_inst == null) {
            PresetGeometries presetGeometries = new PresetGeometries();
            try {
                InputStream inputStream = PresetGeometries.class.getResourceAsStream("presetShapeDefinitions.xml");
                try {
                    presetGeometries.init(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            _inst = presetGeometries;
        }
        return _inst;
    }
}

