/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw.geom;

import ai2.org.apache.poi.sl.draw.binding.CTAdjPoint2D;
import ai2.org.apache.poi.sl.draw.binding.CTPath2D;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DArcTo;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DClose;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DCubicBezierTo;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DLineTo;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DMoveTo;
import ai2.org.apache.poi.sl.draw.binding.CTPath2DQuadBezierTo;
import ai2.org.apache.poi.sl.draw.binding.STPathFillMode;
import ai2.org.apache.poi.sl.draw.geom.ArcToCommand;
import ai2.org.apache.poi.sl.draw.geom.ClosePathCommand;
import ai2.org.apache.poi.sl.draw.geom.Context;
import ai2.org.apache.poi.sl.draw.geom.CurveToCommand;
import ai2.org.apache.poi.sl.draw.geom.LineToCommand;
import ai2.org.apache.poi.sl.draw.geom.MoveToCommand;
import ai2.org.apache.poi.sl.draw.geom.PathCommand;
import ai2.org.apache.poi.sl.draw.geom.QuadToCommand;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class Path {
    private final List<PathCommand> commands;
    boolean _fill;
    boolean _stroke;
    long _w;
    long _h;

    public Path() {
        this(true, true);
    }

    public Path(boolean bl, boolean bl2) {
        this.commands = new ArrayList<PathCommand>();
        this._w = -1L;
        this._h = -1L;
        this._fill = bl;
        this._stroke = bl2;
    }

    public Path(CTPath2D cTPath2D) {
        this._fill = cTPath2D.getFill() != STPathFillMode.NONE;
        this._stroke = cTPath2D.isStroke();
        this._w = cTPath2D.isSetW() ? cTPath2D.getW() : -1L;
        this._h = cTPath2D.isSetH() ? cTPath2D.getH() : -1L;
        this.commands = new ArrayList<PathCommand>();
        for (Object object : cTPath2D.getCloseOrMoveToOrLnTo()) {
            CTAdjPoint2D cTAdjPoint2D;
            CTAdjPoint2D cTAdjPoint2D2;
            Object object2;
            if (object instanceof CTPath2DMoveTo) {
                object2 = ((CTPath2DMoveTo)object).getPt();
                this.commands.add(new MoveToCommand((CTAdjPoint2D)object2));
                continue;
            }
            if (object instanceof CTPath2DLineTo) {
                object2 = ((CTPath2DLineTo)object).getPt();
                this.commands.add(new LineToCommand((CTAdjPoint2D)object2));
                continue;
            }
            if (object instanceof CTPath2DArcTo) {
                object2 = (CTPath2DArcTo)object;
                this.commands.add(new ArcToCommand((CTPath2DArcTo)object2));
                continue;
            }
            if (object instanceof CTPath2DQuadBezierTo) {
                object2 = (CTPath2DQuadBezierTo)object;
                cTAdjPoint2D2 = ((CTPath2DQuadBezierTo)object2).getPt().get(0);
                cTAdjPoint2D = ((CTPath2DQuadBezierTo)object2).getPt().get(1);
                this.commands.add(new QuadToCommand(cTAdjPoint2D2, cTAdjPoint2D));
                continue;
            }
            if (object instanceof CTPath2DCubicBezierTo) {
                object2 = (CTPath2DCubicBezierTo)object;
                cTAdjPoint2D2 = ((CTPath2DCubicBezierTo)object2).getPt().get(0);
                cTAdjPoint2D = ((CTPath2DCubicBezierTo)object2).getPt().get(1);
                CTAdjPoint2D cTAdjPoint2D3 = ((CTPath2DCubicBezierTo)object2).getPt().get(2);
                this.commands.add(new CurveToCommand(cTAdjPoint2D2, cTAdjPoint2D, cTAdjPoint2D3));
                continue;
            }
            if (object instanceof CTPath2DClose) {
                this.commands.add(new ClosePathCommand());
                continue;
            }
            throw new IllegalStateException("Unsupported path segment: " + object);
        }
    }

    public void addCommand(PathCommand pathCommand) {
        this.commands.add(pathCommand);
    }

    public GeneralPath getPath(Context context) {
        GeneralPath generalPath = new GeneralPath();
        for (PathCommand pathCommand : this.commands) {
            pathCommand.execute(generalPath, context);
        }
        return generalPath;
    }

    public boolean isStroked() {
        return this._stroke;
    }

    public boolean isFilled() {
        return this._fill;
    }

    public long getW() {
        return this._w;
    }

    public long getH() {
        return this._h;
    }
}

