/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw.geom;

import ai2.org.apache.poi.sl.draw.geom.CustomGeometry;
import ai2.org.apache.poi.sl.draw.geom.Formula;
import ai2.org.apache.poi.sl.draw.geom.Guide;
import ai2.org.apache.poi.sl.draw.geom.IAdjustableShape;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class Context {
    final Map<String, Double> _ctx = new HashMap<String, Double>();
    final IAdjustableShape _props;
    final Rectangle2D _anchor;

    public Context(CustomGeometry customGeometry, Rectangle2D rectangle2D, IAdjustableShape iAdjustableShape) {
        this._props = iAdjustableShape;
        this._anchor = rectangle2D;
        for (Guide guide : customGeometry.adjusts) {
            this.evaluate(guide);
        }
        for (Guide guide : customGeometry.guides) {
            this.evaluate(guide);
        }
    }

    public Rectangle2D getShapeAnchor() {
        return this._anchor;
    }

    public Guide getAdjustValue(String string) {
        return this._props.getAdjustValue(string);
    }

    public double getValue(String string) {
        if (string.matches("(\\+|-)?\\d+")) {
            return Double.parseDouble(string);
        }
        Formula formula = Formula.builtInFormulas.get(string);
        if (formula != null) {
            return formula.evaluate(this);
        }
        if (!this._ctx.containsKey(string)) {
            throw new RuntimeException("undefined variable: " + string);
        }
        return this._ctx.get(string);
    }

    public double evaluate(Formula formula) {
        double d = formula.evaluate(this);
        String string = formula.getName();
        if (string != null) {
            this._ctx.put(string, d);
        }
        return d;
    }
}

