/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageRenderer {
    private static final POILogger LOG = POILogFactory.getLogger(ImageRenderer.class);
    protected BufferedImage img;

    public void loadImage(InputStream inputStream, String string) throws IOException {
        this.img = ImageRenderer.convertBufferedImage(ImageIO.read(inputStream), string);
    }

    public void loadImage(byte[] byArray, String string) throws IOException {
        this.img = ImageRenderer.convertBufferedImage(ImageIO.read(new ByteArrayInputStream(byArray)), string);
    }

    private static BufferedImage convertBufferedImage(BufferedImage bufferedImage, String string) {
        if (bufferedImage == null) {
            LOG.log(5, new Object[]{"Content-type: " + string + " is not support. Image ignored."});
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Dimension getDimension() {
        return this.img == null ? new Dimension(0, 0) : new Dimension(this.img.getWidth(), this.img.getHeight());
    }

    public void setAlpha(double d) {
        if (this.img == null) {
            return;
        }
        Dimension dimension = this.getDimension();
        BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RescaleOp rescaleOp = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)d}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        graphics2D.drawImage(this.img, rescaleOp, 0, 0);
        graphics2D.dispose();
        this.img = bufferedImage;
    }

    public boolean drawImage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.drawImage(graphics2D, rectangle2D, null);
    }

    public boolean drawImage(Graphics2D graphics2D, Rectangle2D rectangle2D, Insets insets) {
        if (this.img == null) {
            return false;
        }
        boolean bl = true;
        if (insets == null) {
            bl = false;
            insets = new Insets(0, 0, 0, 0);
        }
        int n = this.img.getWidth();
        int n2 = this.img.getHeight();
        double d = (double)(100000 - insets.left - insets.right) / 100000.0;
        double d2 = (double)(100000 - insets.top - insets.bottom) / 100000.0;
        double d3 = rectangle2D.getWidth() / ((double)n * d);
        double d4 = rectangle2D.getHeight() / ((double)n2 * d2);
        double d5 = rectangle2D.getX() - (double)n * d3 * (double)insets.left / 100000.0;
        double d6 = rectangle2D.getY() - (double)n2 * d4 * (double)insets.top / 100000.0;
        AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d5, d6);
        Shape shape = graphics2D.getClip();
        if (bl) {
            graphics2D.clip(rectangle2D.getBounds2D());
        }
        graphics2D.drawRenderedImage(this.img, affineTransform);
        graphics2D.setClip(shape);
        return true;
    }
}

