/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawShape;
import ai2.org.apache.poi.sl.draw.DrawSimpleShape;
import ai2.org.apache.poi.sl.draw.DrawTextParagraph;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.Insets2D;
import ai2.org.apache.poi.sl.usermodel.SimpleShape;
import ai2.org.apache.poi.sl.usermodel.TextParagraph;
import ai2.org.apache.poi.sl.usermodel.TextShape;
import ai2.org.apache.poi.util.JvmBugs;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawTextShape
extends DrawSimpleShape {
    public DrawTextShape(TextShape<?, ?> textShape) {
        super((SimpleShape<?, ?>)textShape);
    }

    @Override
    public void drawContent(Graphics2D graphics2D) {
        double d;
        double d2;
        DrawTextShape.fixFonts(graphics2D);
        Rectangle2D rectangle2D = DrawShape.getAnchor(graphics2D, this.getShape());
        Insets2D insets2D = this.getShape().getInsets();
        double d3 = rectangle2D.getX() + insets2D.left;
        double d4 = rectangle2D.getY();
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.getShape().getFlipVertical()) {
            graphics2D.translate(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
            d2 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
            d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            graphics2D.translate(d2, d);
            graphics2D.rotate(Math.toRadians(180.0));
            graphics2D.translate(-d2, -d);
        }
        if (this.getShape().getFlipHorizontal()) {
            graphics2D.translate(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            graphics2D.scale(-1.0, 1.0);
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        }
        d2 = this.getShape().getTextHeight();
        switch (this.getShape().getVerticalAlignment()) {
            case TOP: {
                d4 += insets2D.top;
                break;
            }
            case BOTTOM: {
                d4 += rectangle2D.getHeight() - d2 - insets2D.bottom;
                break;
            }
            default: {
                d = rectangle2D.getHeight() - d2 - insets2D.top - insets2D.bottom;
                d4 += insets2D.top + d / 2.0;
            }
        }
        this.drawParagraphs(graphics2D, d3, d4);
        graphics2D.setTransform(affineTransform);
    }

    public double drawParagraphs(Graphics2D graphics2D, double d, double d2) {
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        double d3 = d2;
        Iterator iterator = this.getShape().iterator();
        boolean bl = true;
        int n = 0;
        while (iterator.hasNext()) {
            Number number;
            TextParagraph textParagraph = (TextParagraph)iterator.next();
            DrawTextParagraph drawTextParagraph = drawFactory.getDrawable(textParagraph);
            TextParagraph.BulletStyle bulletStyle = textParagraph.getBulletStyle();
            if (bulletStyle == null || bulletStyle.getAutoNumberingScheme() == null) {
                n = -1;
            } else {
                number = bulletStyle.getAutoNumberingStartAt();
                if (number == null) {
                    number = 1;
                }
                if ((Integer)number > n) {
                    n = (Integer)number;
                }
            }
            drawTextParagraph.setAutoNumberingIdx(n);
            drawTextParagraph.breakText(graphics2D);
            if (!bl) {
                number = textParagraph.getSpaceBefore();
                if (number == null) {
                    number = 0.0;
                }
                d2 = (Double)number > 0.0 ? (d2 += (Double)number * 0.01 * (double)drawTextParagraph.getFirstLineHeight()) : (d2 += -((Double)number).doubleValue());
            }
            bl = false;
            drawTextParagraph.setPosition(d, d2);
            drawTextParagraph.draw(graphics2D);
            d2 += drawTextParagraph.getY();
            if (iterator.hasNext()) {
                number = textParagraph.getSpaceAfter();
                if (number == null) {
                    number = 0.0;
                }
                d2 = (Double)number > 0.0 ? (d2 += (Double)number * 0.01 * (double)drawTextParagraph.getLastLineHeight()) : (d2 += -((Double)number).doubleValue());
            }
            ++n;
        }
        return d2 - d3;
    }

    public double getTextHeight() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        DrawTextShape.fixFonts(graphics2D);
        return this.drawParagraphs(graphics2D, 0.0, 0.0);
    }

    private static void fixFonts(Graphics2D graphics2D) {
        if (!JvmBugs.hasLineBreakMeasurerBug()) {
            return;
        }
        HashMap<String, String> hashMap = (HashMap<String, String>)graphics2D.getRenderingHint(Drawable.FONT_MAP);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            graphics2D.setRenderingHint(Drawable.FONT_MAP, hashMap);
        }
        if (!hashMap.containsKey("Calibri")) {
            hashMap.put("Calibri", "Lucida Sans");
        }
        if (!hashMap.containsKey("Cambria")) {
            hashMap.put("Cambria", "Lucida Bright");
        }
    }

    @Override
    protected TextShape<?, ?> getShape() {
        return (TextShape)this.shape;
    }
}

