/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawFontManager;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.draw.DrawShape;
import ai2.org.apache.poi.sl.draw.DrawTextFragment;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.AutoNumberingScheme;
import ai2.org.apache.poi.sl.usermodel.Insets2D;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.TextParagraph;
import ai2.org.apache.poi.sl.usermodel.TextRun;
import ai2.org.apache.poi.sl.usermodel.TextShape;
import ai2.org.apache.poi.util.Units;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawTextParagraph
implements Drawable {
    protected TextParagraph<?, ?, ?> paragraph;
    double x;
    double y;
    protected List<DrawTextFragment> lines = new ArrayList<DrawTextFragment>();
    protected String rawText;
    protected DrawTextFragment bullet;
    protected int autoNbrIdx = 0;
    protected double maxLineHeight;

    public DrawTextParagraph(TextParagraph<?, ?, ?> textParagraph) {
        this.paragraph = textParagraph;
    }

    public void setPosition(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double getY() {
        return this.y;
    }

    public void setAutoNumberingIdx(int n) {
        this.autoNbrIdx = n;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Double d;
        Double d2;
        if (this.lines.isEmpty()) {
            return;
        }
        double d3 = this.y;
        boolean bl = true;
        int n = this.paragraph.getIndentLevel();
        Double d4 = this.paragraph.getLeftMargin();
        if (d4 == null) {
            d4 = Units.toPoints(347663 * n);
        }
        if ((d2 = this.paragraph.getIndent()) == null) {
            d2 = Units.toPoints(347663 * n);
        }
        if (this.paragraph.getClass().getName().contains("HSLF")) {
            d2 = d2 - d4;
        }
        if ((d = this.paragraph.getLineSpacing()) == null) {
            d = 100.0;
        }
        for (DrawTextFragment drawTextFragment : this.lines) {
            double d5;
            if (bl) {
                if (!this.isEmptyParagraph()) {
                    this.bullet = this.getBullet(graphics2D, drawTextFragment.getAttributedString().getIterator());
                }
                if (this.bullet != null) {
                    this.bullet.setPosition(this.x + d4 + d2, d3);
                    this.bullet.draw(graphics2D);
                    double d6 = this.bullet.getLayout().getAdvance() + 1.0f;
                    d5 = this.x + Math.max(d4, d4 + d2 + d6);
                } else {
                    d5 = this.x + d4;
                }
            } else {
                d5 = this.x + d4;
            }
            Rectangle2D rectangle2D = DrawShape.getAnchor(graphics2D, this.paragraph.getParentShape());
            Insets2D insets2D = this.paragraph.getParentShape().getInsets();
            double d7 = insets2D.left;
            double d8 = insets2D.right;
            TextParagraph.TextAlign textAlign = this.paragraph.getTextAlign();
            if (textAlign == null) {
                textAlign = TextParagraph.TextAlign.LEFT;
            }
            switch (textAlign) {
                case CENTER: {
                    d5 += (rectangle2D.getWidth() - (double)drawTextFragment.getWidth() - d7 - d8 - d4) / 2.0;
                    break;
                }
                case RIGHT: {
                    d5 += rectangle2D.getWidth() - (double)drawTextFragment.getWidth() - d7 - d8;
                    break;
                }
            }
            drawTextFragment.setPosition(d5, d3);
            drawTextFragment.draw(graphics2D);
            d3 = d > 0.0 ? (d3 += d * 0.01 * (double)drawTextFragment.getHeight()) : (d3 += -d.doubleValue());
            bl = false;
        }
        this.y = d3 - this.y;
    }

    public float getFirstLineHeight() {
        return this.lines.isEmpty() ? 0.0f : this.lines.get(0).getHeight();
    }

    public float getLastLineHeight() {
        return this.lines.isEmpty() ? 0.0f : this.lines.get(this.lines.size() - 1).getHeight();
    }

    public boolean isEmptyParagraph() {
        return this.lines.isEmpty() || this.rawText.trim().isEmpty();
    }

    @Override
    public void applyTransform(Graphics2D graphics2D) {
    }

    @Override
    public void drawContent(Graphics2D graphics2D) {
    }

    protected void breakText(Graphics2D graphics2D) {
        int n;
        this.lines.clear();
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        StringBuilder stringBuilder = new StringBuilder();
        AttributedString attributedString = this.getAttributedString(graphics2D, stringBuilder);
        boolean bl = "".equals(stringBuilder.toString().trim());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, graphics2D.getFontRenderContext());
        do {
            TextParagraph.TextAlign textAlign;
            TextLayout textLayout;
            int n2;
            int n3 = lineBreakMeasurer.getPosition();
            double d = this.getWrappingWidth(this.lines.size() == 0, graphics2D) + 1.0;
            if (d < 0.0) {
                d = 1.0;
            }
            if ((n2 = stringBuilder.indexOf("\n", n3 + 1)) == -1) {
                n2 = attributedCharacterIterator.getEndIndex();
            }
            if ((textLayout = lineBreakMeasurer.nextLayout((float)d, n2, true)) == null) {
                textLayout = lineBreakMeasurer.nextLayout((float)d, n2, false);
            }
            if (textLayout == null) break;
            n = lineBreakMeasurer.getPosition();
            if (n < attributedCharacterIterator.getEndIndex() && stringBuilder.charAt(n) == '\n') {
                lineBreakMeasurer.setPosition(n + 1);
            }
            if ((textAlign = this.paragraph.getTextAlign()) == TextParagraph.TextAlign.JUSTIFY || textAlign == TextParagraph.TextAlign.JUSTIFY_LOW) {
                textLayout = textLayout.getJustifiedLayout((float)d);
            }
            AttributedString attributedString2 = bl ? null : new AttributedString(attributedCharacterIterator, n3, n);
            DrawTextFragment drawTextFragment = drawFactory.getTextFragment(textLayout, attributedString2);
            this.lines.add(drawTextFragment);
            this.maxLineHeight = Math.max(this.maxLineHeight, (double)drawTextFragment.getHeight());
        } while (n != attributedCharacterIterator.getEndIndex());
        this.rawText = stringBuilder.toString();
    }

    protected DrawTextFragment getBullet(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        TextParagraph.BulletStyle bulletStyle = this.paragraph.getBulletStyle();
        if (bulletStyle == null) {
            return null;
        }
        AutoNumberingScheme autoNumberingScheme = bulletStyle.getAutoNumberingScheme();
        String string = autoNumberingScheme != null ? autoNumberingScheme.format(this.autoNbrIdx) : bulletStyle.getBulletCharacter();
        if (string == null) {
            return null;
        }
        String string2 = bulletStyle.getBulletFont();
        if (string2 == null) {
            string2 = this.paragraph.getDefaultFontFamily();
        }
        assert (string2 != null);
        PlaceableShape<?, ?> placeableShape = this.getParagraphShape();
        PaintStyle paintStyle = bulletStyle.getBulletFontColor();
        Paint paint = paintStyle == null ? (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND) : new DrawPaint(placeableShape).getPaint(graphics2D, paintStyle);
        float f = ((Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE)).floatValue();
        Double d = bulletStyle.getBulletFontSize();
        if (d == null) {
            d = 100.0;
        }
        f = d > 0.0 ? (float)((double)f * (d * 0.01)) : (float)(-d.doubleValue());
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FOREGROUND, paint);
        attributedString.addAttribute(TextAttribute.FAMILY, string2);
        attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf(f));
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        return drawFactory.getTextFragment(textLayout, attributedString);
    }

    protected String getRenderableText(TextRun textRun) {
        StringBuilder stringBuilder = new StringBuilder();
        TextRun.TextCap textCap = textRun.getTextCap();
        String string = null;
        for (char c : textRun.getRawText().toCharArray()) {
            if (c == '\t') {
                if (string == null) {
                    string = this.tab2space(textRun);
                }
                stringBuilder.append(string);
                continue;
            }
            switch (textCap) {
                case ALL: {
                    c = Character.toUpperCase(c);
                    break;
                }
                case SMALL: {
                    c = Character.toLowerCase(c);
                    break;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String tab2space(TextRun textRun) {
        AttributedString attributedString = new AttributedString(" ");
        String string = textRun.getFontFamily();
        if (string == null) {
            string = "Lucida Sans";
        }
        attributedString.addAttribute(TextAttribute.FAMILY, string);
        Double d = textRun.getFontSize();
        if (d == null) {
            d = 12.0;
        }
        attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf(d.floatValue()));
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), new FontRenderContext(null, true, true));
        double d2 = textLayout.getAdvance();
        Double d3 = this.paragraph.getDefaultTabSize();
        if (d3 == null) {
            d3 = d2 * 4.0;
        }
        int n = (int)Math.ceil(d3 / d2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    protected double getWrappingWidth(boolean bl, Graphics2D graphics2D) {
        double d;
        TextShape<?, ?> textShape;
        Double d2;
        Double d3;
        Insets2D insets2D = this.paragraph.getParentShape().getInsets();
        double d4 = insets2D.left;
        double d5 = insets2D.right;
        Rectangle2D rectangle2D = DrawShape.getAnchor(graphics2D, this.paragraph.getParentShape());
        int n = this.paragraph.getIndentLevel();
        Double d6 = this.paragraph.getLeftMargin();
        if (d6 == null) {
            d6 = Units.toPoints(347663 * (n + 1));
        }
        if ((d3 = this.paragraph.getIndent()) == null) {
            d3 = Units.toPoints(347663 * n);
        }
        if ((d2 = this.paragraph.getRightMargin()) == null) {
            d2 = 0.0;
        }
        if (!(textShape = this.paragraph.getParentShape()).getWordWrap()) {
            d = textShape.getSheet().getSlideShow().getPageSize().getWidth() - rectangle2D.getX();
        } else {
            d = rectangle2D.getWidth() - d4 - d5 - d6 - d2;
            if (bl) {
                if (this.bullet != null) {
                    if (d3 > 0.0) {
                        d -= d3.doubleValue();
                    }
                } else if (d3 > 0.0) {
                    d -= d3.doubleValue();
                } else if (d3 < 0.0) {
                    d += d6.doubleValue();
                }
            }
        }
        return d;
    }

    private PlaceableShape<?, ?> getParagraphShape() {
        PlaceableShape placeableShape = new PlaceableShape(){

            public ShapeContainer<?, ?> getParent() {
                return null;
            }

            @Override
            public Rectangle getAnchor() {
                return DrawTextParagraph.this.paragraph.getParentShape().getAnchor();
            }

            @Override
            public void setAnchor(Rectangle rectangle) {
            }

            @Override
            public double getRotation() {
                return 0.0;
            }

            @Override
            public void setRotation(double d) {
            }

            @Override
            public void setFlipHorizontal(boolean bl) {
            }

            @Override
            public void setFlipVertical(boolean bl) {
            }

            @Override
            public boolean getFlipHorizontal() {
                return false;
            }

            @Override
            public boolean getFlipVertical() {
                return false;
            }
        };
        return placeableShape;
    }

    protected AttributedString getAttributedString(Graphics2D graphics2D, StringBuilder stringBuilder) {
        Object object;
        ArrayList<AttributedStringData> arrayList = new ArrayList<AttributedStringData>();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        PlaceableShape<?, ?> placeableShape = this.getParagraphShape();
        DrawFontManager drawFontManager = (DrawFontManager)graphics2D.getRenderingHint(Drawable.FONT_HANDLER);
        for (Object object2 : this.paragraph) {
            String object3 = this.getRenderableText((TextRun)object2);
            if (object3.isEmpty()) continue;
            int n = stringBuilder.length();
            stringBuilder.append(object3);
            int n2 = stringBuilder.length();
            PaintStyle paintStyle = object2.getFontColor();
            Paint paint = new DrawPaint(placeableShape).getPaint(graphics2D, paintStyle);
            arrayList.add(new AttributedStringData(TextAttribute.FOREGROUND, paint, n, n2));
            String string = object2.getFontFamily();
            Map map = (Map)graphics2D.getRenderingHint(Drawable.FONT_MAP);
            if (map != null && map.containsKey(string)) {
                string = (String)map.get(string);
            }
            if (drawFontManager != null) {
                string = drawFontManager.getRendererableFont(string, object2.getPitchAndFamily());
            }
            if (string == null) {
                string = this.paragraph.getDefaultFontFamily();
            }
            arrayList.add(new AttributedStringData(TextAttribute.FAMILY, string, n, n2));
            Double d = object2.getFontSize();
            if (d == null) {
                d = this.paragraph.getDefaultFontSize();
            }
            arrayList.add(new AttributedStringData(TextAttribute.SIZE, Float.valueOf(d.floatValue()), n, n2));
            if (object2.isBold()) {
                arrayList.add(new AttributedStringData(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, n, n2));
            }
            if (object2.isItalic()) {
                arrayList.add(new AttributedStringData(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, n, n2));
            }
            if (object2.isUnderlined()) {
                arrayList.add(new AttributedStringData(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, n, n2));
                arrayList.add(new AttributedStringData(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, n, n2));
            }
            if (object2.isStrikethrough()) {
                arrayList.add(new AttributedStringData(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, n, n2));
            }
            if (object2.isSubscript()) {
                arrayList.add(new AttributedStringData(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, n, n2));
            }
            if (!object2.isSuperscript()) continue;
            arrayList.add(new AttributedStringData(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, n, n2));
        }
        if (stringBuilder.length() == 0) {
            object = this.paragraph.getDefaultFontSize();
            stringBuilder.append(" ");
            arrayList.add(new AttributedStringData(TextAttribute.SIZE, Float.valueOf(((Double)object).floatValue()), 0, 1));
        }
        object = new AttributedString(stringBuilder.toString());
        for (AttributedStringData attributedStringData : arrayList) {
            ((AttributedString)object).addAttribute(attributedStringData.attribute, attributedStringData.value, attributedStringData.beginIndex, attributedStringData.endIndex);
        }
        return object;
    }

    private static class AttributedStringData {
        AttributedCharacterIterator.Attribute attribute;
        Object value;
        int beginIndex;
        int endIndex;

        AttributedStringData(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            this.attribute = attribute;
            this.value = object;
            this.beginIndex = n;
            this.endIndex = n2;
        }
    }
}

