/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.Drawable;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class DrawTextFragment
implements Drawable {
    final TextLayout layout;
    final AttributedString str;
    double x;
    double y;

    public DrawTextFragment(TextLayout textLayout, AttributedString attributedString) {
        this.layout = textLayout;
        this.str = attributedString;
    }

    public void setPosition(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.str == null) {
            return;
        }
        double d = this.y + (double)this.layout.getAscent();
        Integer n = (Integer)graphics2D.getRenderingHint(Drawable.TEXT_RENDERING_MODE);
        if (n != null && n == 2) {
            this.layout.draw(graphics2D, (float)this.x, (float)d);
        } else {
            graphics2D.drawString(this.str.getIterator(), (float)this.x, (float)d);
        }
    }

    public void applyTransform(Graphics2D graphics2D) {
    }

    public void drawContent(Graphics2D graphics2D) {
    }

    public TextLayout getLayout() {
        return this.layout;
    }

    public AttributedString getAttributedString() {
        return this.str;
    }

    public float getHeight() {
        double d = Math.ceil(this.layout.getAscent()) + Math.ceil(this.layout.getDescent()) + (double)this.layout.getLeading();
        return (float)d;
    }

    public float getWidth() {
        return this.layout.getAdvance();
    }

    public String getString() {
        if (this.str == null) {
            return "";
        }
        AttributedCharacterIterator attributedCharacterIterator = this.str.getIterator();
        StringBuilder stringBuilder = new StringBuilder();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuilder.append(c);
            c = attributedCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getString();
    }
}

