/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.sl.usermodel.Shape;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawShape
implements Drawable {
    protected final Shape<?, ?> shape;

    public DrawShape(Shape<?, ?> shape) {
        this.shape = shape;
    }

    @Override
    public void applyTransform(Graphics2D graphics2D) {
        if (!(this.shape instanceof PlaceableShape)) {
            return;
        }
        PlaceableShape placeableShape = (PlaceableShape)((Object)this.shape);
        AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(placeableShape.getAnchor()).getBounds2D();
        double d = placeableShape.getRotation();
        if (d != 0.0) {
            double d2 = rectangle2D.getCenterX();
            double d3 = rectangle2D.getCenterY();
            if ((d %= 360.0) < 0.0) {
                d += 360.0;
            }
            int n = ((int)d + 45) / 90 % 4;
            double d4 = 1.0;
            double d5 = 1.0;
            if (n == 1 || n == 3) {
                AffineTransform affineTransform2;
                if (placeableShape.getClass().getCanonicalName().toLowerCase(Locale.ROOT).contains("hslf")) {
                    affineTransform2 = new AffineTransform(affineTransform);
                } else {
                    affineTransform2 = new AffineTransform();
                    affineTransform2.translate(d2, d3);
                    affineTransform2.rotate(1.5707963267948966);
                    affineTransform2.translate(-d2, -d3);
                    affineTransform2.concatenate(affineTransform);
                }
                affineTransform2.translate(d2, d3);
                affineTransform2.rotate(1.5707963267948966);
                affineTransform2.translate(-d2, -d3);
                Rectangle2D rectangle2D2 = affineTransform2.createTransformedShape(placeableShape.getAnchor()).getBounds2D();
                d4 = rectangle2D.getWidth() == 0.0 ? 1.0 : rectangle2D.getWidth() / rectangle2D2.getWidth();
                d5 = rectangle2D.getHeight() == 0.0 ? 1.0 : rectangle2D.getHeight() / rectangle2D2.getHeight();
            } else {
                n = 0;
            }
            graphics2D.translate(d2, d3);
            graphics2D.rotate(Math.toRadians(d - (double)n * 90.0));
            graphics2D.scale(d4, d5);
            graphics2D.rotate(Math.toRadians(n * 90));
            graphics2D.translate(-d2, -d3);
        }
        if (placeableShape.getFlipHorizontal()) {
            graphics2D.translate(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            graphics2D.scale(-1.0, 1.0);
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        }
        if (placeableShape.getFlipVertical()) {
            graphics2D.translate(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
    }

    @Override
    public void drawContent(Graphics2D graphics2D) {
    }

    public static Rectangle2D getAnchor(Graphics2D graphics2D, PlaceableShape<?, ?> placeableShape) {
        return DrawShape.getAnchor(graphics2D, placeableShape.getAnchor());
    }

    public static Rectangle2D getAnchor(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (graphics2D == null) {
            return rectangle2D;
        }
        AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (affineTransform != null) {
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    protected Shape<?, ?> getShape() {
        return this.shape;
    }
}

