/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawSimpleShape;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.draw.ImageRenderer;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.PictureShape;
import ai2.org.apache.poi.sl.usermodel.RectAlign;
import ai2.org.apache.poi.sl.usermodel.SimpleShape;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawPictureShape
extends DrawSimpleShape {
    public DrawPictureShape(PictureShape<?, ?> pictureShape) {
        super((SimpleShape<?, ?>)pictureShape);
    }

    @Override
    public void drawContent(Graphics2D graphics2D) {
        PictureData pictureData = this.getShape().getPictureData();
        if (pictureData == null) {
            return;
        }
        ImageRenderer imageRenderer = (ImageRenderer)graphics2D.getRenderingHint(Drawable.IMAGE_RENDERER);
        if (imageRenderer == null) {
            imageRenderer = new ImageRenderer();
        }
        Rectangle2D rectangle2D = DrawPictureShape.getAnchor(graphics2D, this.getShape());
        Insets insets = this.getShape().getClipping();
        try {
            imageRenderer.loadImage(pictureData.getData(), pictureData.getContentType());
            imageRenderer.drawImage(graphics2D, rectangle2D, insets);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected PictureShape<?, ?> getShape() {
        return (PictureShape)this.shape;
    }

    public void resize() {
        SimpleShape simpleShape = this.getShape();
        Dimension dimension = simpleShape.getPictureData().getImageDimension();
        Rectangle rectangle = simpleShape.getAnchor();
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        simpleShape.setAnchor(new Rectangle(n, n2, n3, n4));
    }

    public void resize(Rectangle rectangle) {
        this.resize(rectangle, RectAlign.CENTER);
    }

    public void resize(Rectangle rectangle, RectAlign rectAlign) {
        SimpleShape simpleShape = this.getShape();
        Dimension dimension = simpleShape.getPictureData().getImageDimension();
        if (dimension.width <= 0 || dimension.height <= 0) {
            simpleShape.setAnchor(rectangle);
            return;
        }
        double d = rectangle.getWidth();
        double d2 = rectangle.getHeight();
        double d3 = d / (double)dimension.width;
        double d4 = d2 / (double)dimension.height;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 > d4) {
            d = d4 * (double)dimension.width;
            d5 = rectangle.getWidth() - d;
        } else if (d4 > d3) {
            d2 = d3 * (double)dimension.height;
            d6 = rectangle.getHeight() - d2;
        } else {
            simpleShape.setAnchor(rectangle);
            return;
        }
        double d7 = rectangle.getX();
        double d8 = rectangle.getY();
        switch (rectAlign) {
            case TOP: {
                d7 += d5 / 2.0;
                break;
            }
            case TOP_RIGHT: {
                d7 += d5;
                break;
            }
            case RIGHT: {
                d7 += d5;
                d8 += d6 / 2.0;
                break;
            }
            case BOTTOM_RIGHT: {
                d7 += d5;
                d8 += d6;
                break;
            }
            case BOTTOM: {
                d7 += d5 / 2.0;
                d8 += d6;
                break;
            }
            case BOTTOM_LEFT: {
                d8 += d6;
                break;
            }
            case LEFT: {
                d8 += d6 / 2.0;
                break;
            }
            case TOP_LEFT: {
                break;
            }
            default: {
                d7 += d5 / 2.0;
                d8 += d6 / 2.0;
            }
        }
        simpleShape.setAnchor(new Rectangle((int)d7, (int)d8, (int)d, (int)d2));
    }
}

