/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawShape;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.draw.ImageRenderer;
import ai2.org.apache.poi.sl.draw.PathGradientPaint;
import ai2.org.apache.poi.sl.usermodel.ColorStyle;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    protected PlaceableShape<?, ?> shape;

    public DrawPaint(PlaceableShape<?, ?> placeableShape) {
        this.shape = placeableShape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(Color color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public static PaintStyle.SolidPaint createSolidPaint(ColorStyle colorStyle) {
        return colorStyle == null ? null : new SimpleSolidPaint(colorStyle);
    }

    public Paint getPaint(Graphics2D graphics2D, PaintStyle paintStyle) {
        if (paintStyle instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paintStyle, graphics2D);
        }
        if (paintStyle instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paintStyle, graphics2D);
        }
        if (paintStyle instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paintStyle, graphics2D);
        }
        return null;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint solidPaint, Graphics2D graphics2D) {
        return DrawPaint.applyColorTransform(solidPaint.getSolidColor());
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint gradientPaint, Graphics2D graphics2D) {
        switch (gradientPaint.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(gradientPaint, graphics2D);
            }
            case circular: {
                return this.createRadialGradientPaint(gradientPaint, graphics2D);
            }
            case shape: {
                return this.createPathGradientPaint(gradientPaint, graphics2D);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + gradientPaint + " not supported.");
    }

    protected Paint getTexturePaint(PaintStyle.TexturePaint texturePaint, Graphics2D graphics2D) {
        InputStream inputStream = texturePaint.getImageData();
        if (inputStream == null) {
            return null;
        }
        assert (graphics2D != null);
        ImageRenderer imageRenderer = (ImageRenderer)graphics2D.getRenderingHint(Drawable.IMAGE_RENDERER);
        if (imageRenderer == null) {
            imageRenderer = new ImageRenderer();
        }
        try {
            imageRenderer.loadImage(inputStream, texturePaint.getContentType());
            inputStream.close();
        }
        catch (IOException iOException) {
            LOG.log(7, new Object[]{"Can't load image data - using transparent color", iOException});
            return null;
        }
        int n = texturePaint.getAlpha();
        if (0 <= n && n < 100000) {
            imageRenderer.setAlpha((float)n / 100000.0f);
        }
        Rectangle rectangle = this.shape.getAnchor();
        TexturePaint texturePaint2 = new TexturePaint(imageRenderer.getImage(), rectangle);
        return texturePaint2;
    }

    public static Color applyColorTransform(ColorStyle colorStyle) {
        Color color = colorStyle.getColor();
        if (color == null) {
            return null;
        }
        double d = DrawPaint.getAlpha(color, colorStyle);
        double[] dArray = DrawPaint.RGB2HSL(color);
        DrawPaint.applyHslModOff(dArray, 0, colorStyle.getHueMod(), colorStyle.getHueOff());
        DrawPaint.applyHslModOff(dArray, 1, colorStyle.getSatMod(), colorStyle.getSatOff());
        DrawPaint.applyHslModOff(dArray, 2, colorStyle.getLumMod(), colorStyle.getLumOff());
        DrawPaint.applyShade(dArray, colorStyle);
        DrawPaint.applyTint(dArray, colorStyle);
        color = DrawPaint.HSL2RGB(dArray[0], dArray[1], dArray[2], d);
        return color;
    }

    private static double getAlpha(Color color, ColorStyle colorStyle) {
        double d = (double)color.getAlpha() / 255.0;
        int n = colorStyle.getAlpha();
        if (n != -1) {
            d *= (double)n / 100000.0;
        }
        return Math.min(1.0, Math.max(0.0, d));
    }

    private static void applyHslModOff(double[] dArray, int n, int n2, int n3) {
        if (n2 == -1) {
            n2 = 100000;
        }
        if (n3 == -1) {
            n3 = 0;
        }
        if (n2 != 100000 || n3 != 0) {
            double d = (double)n3 / 1000.0;
            double d2 = (double)n2 / 100000.0;
            dArray[n] = dArray[n] * d2 + d;
        }
    }

    private static void applyShade(double[] dArray, ColorStyle colorStyle) {
        int n = colorStyle.getShade();
        if (n == -1) {
            return;
        }
        double d = (double)n / 100000.0;
        dArray[2] = dArray[2] * d;
    }

    private static void applyTint(double[] dArray, ColorStyle colorStyle) {
        int n = colorStyle.getTint();
        if (n == -1) {
            return;
        }
        double d = (float)n / 100000.0f;
        dArray[2] = dArray[2] * d + (100.0 - d * 100.0);
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint gradientPaint, Graphics2D graphics2D) {
        double d;
        double d2 = gradientPaint.getGradientAngle();
        Rectangle2D rectangle2D = DrawShape.getAnchor(graphics2D, this.shape);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(d2), rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        double d3 = Math.sqrt(rectangle2D.getHeight() * rectangle2D.getHeight() + rectangle2D.getWidth() * rectangle2D.getWidth());
        Point2D point2D = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d3 / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        point2D = affineTransform.transform(point2D, null);
        Point2D point2D2 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        point2D2 = affineTransform.transform(point2D2, null);
        this.snapToAnchor(point2D, rectangle2D);
        this.snapToAnchor(point2D2, rectangle2D);
        float[] fArray = gradientPaint.getGradientFractions();
        Color[] colorArray = new Color[fArray.length];
        int n = 0;
        for (ColorStyle colorStyle : gradientPaint.getGradientColors()) {
            colorArray[n++] = DrawPaint.applyColorTransform(colorStyle);
        }
        AffineTransform affineTransform2 = new AffineTransform();
        if (gradientPaint.isRotatedWithShape() && (d = this.shape.getRotation()) != 0.0) {
            double d4 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
            double d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            affineTransform2.translate(d4, d5);
            affineTransform2.rotate(Math.toRadians(-d));
            affineTransform2.translate(-d4, -d5);
        }
        return new LinearGradientPaint(point2D, point2D2, fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, affineTransform2);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint gradientPaint, Graphics2D graphics2D) {
        Rectangle2D rectangle2D = DrawShape.getAnchor(graphics2D, this.shape);
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        float f = (float)Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        float[] fArray = gradientPaint.getGradientFractions();
        Color[] colorArray = new Color[fArray.length];
        int n = 0;
        for (ColorStyle colorStyle : gradientPaint.getGradientColors()) {
            colorArray[n++] = DrawPaint.applyColorTransform(colorStyle);
        }
        return new RadialGradientPaint(double_, f, fArray, colorArray);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint gradientPaint, Graphics2D graphics2D) {
        float[] fArray = gradientPaint.getGradientFractions();
        Color[] colorArray = new Color[fArray.length];
        int n = 0;
        for (ColorStyle colorStyle : gradientPaint.getGradientColors()) {
            colorArray[n++] = DrawPaint.applyColorTransform(colorStyle);
        }
        return new PathGradientPaint(colorArray, fArray);
    }

    protected void snapToAnchor(Point2D point2D, Rectangle2D rectangle2D) {
        if (point2D.getX() < rectangle2D.getX()) {
            point2D.setLocation(rectangle2D.getX(), point2D.getY());
        } else if (point2D.getX() > rectangle2D.getX() + rectangle2D.getWidth()) {
            point2D.setLocation(rectangle2D.getX() + rectangle2D.getWidth(), point2D.getY());
        }
        if (point2D.getY() < rectangle2D.getY()) {
            point2D.setLocation(point2D.getX(), rectangle2D.getY());
        } else if (point2D.getY() > rectangle2D.getY() + rectangle2D.getHeight()) {
            point2D.setLocation(point2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
        }
    }

    private static Color HSL2RGB(double d, double d2, double d3, double d4) {
        d2 = Math.max(0.0, Math.min(100.0, d2));
        d3 = Math.max(0.0, Math.min(100.0, d3));
        if (d4 < 0.0 || d4 > 1.0) {
            String string = "Color parameter outside of expected range - Alpha: " + d4;
            throw new IllegalArgumentException(string);
        }
        d %= 360.0;
        double d5 = (d3 /= 100.0) < 0.5 ? d3 * (1.0 + d2) : d3 + (d2 /= 100.0) - d2 * d3;
        double d6 = 2.0 * d3 - d5;
        double d7 = Math.max(0.0, DrawPaint.HUE2RGB(d6, d5, (d /= 360.0) + 0.3333333333333333));
        double d8 = Math.max(0.0, DrawPaint.HUE2RGB(d6, d5, d));
        double d9 = Math.max(0.0, DrawPaint.HUE2RGB(d6, d5, d - 0.3333333333333333));
        d7 = Math.min(d7, 1.0);
        d8 = Math.min(d8, 1.0);
        d9 = Math.min(d9, 1.0);
        return new Color((float)d7, (float)d8, (float)d9, (float)d4);
    }

    private static double HUE2RGB(double d, double d2, double d3) {
        if (d3 < 0.0) {
            d3 += 1.0;
        }
        if (d3 > 1.0) {
            d3 -= 1.0;
        }
        if (6.0 * d3 < 1.0) {
            return d + (d2 - d) * 6.0 * d3;
        }
        if (2.0 * d3 < 1.0) {
            return d2;
        }
        if (3.0 * d3 < 2.0) {
            return d + (d2 - d) * 6.0 * (0.6666666666666666 - d3);
        }
        return d;
    }

    private static double[] RGB2HSL(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = fArray[2];
        double d4 = Math.min(d, Math.min(d2, d3));
        double d5 = Math.max(d, Math.max(d2, d3));
        double d6 = 0.0;
        if (d5 == d4) {
            d6 = 0.0;
        } else if (d5 == d) {
            d6 = (60.0 * (d2 - d3) / (d5 - d4) + 360.0) % 360.0;
        } else if (d5 == d2) {
            d6 = 60.0 * (d3 - d) / (d5 - d4) + 120.0;
        } else if (d5 == d3) {
            d6 = 60.0 * (d - d2) / (d5 - d4) + 240.0;
        }
        double d7 = (d5 + d4) / 2.0;
        double d8 = 0.0;
        d8 = d5 == d4 ? 0.0 : (d7 <= 0.5 ? (d5 - d4) / (d5 + d4) : (d5 - d4) / (2.0 - d5 - d4));
        return new double[]{d6, d8 * 100.0, d7 * 100.0};
    }

    private static class SimpleSolidPaint
    implements PaintStyle.SolidPaint {
        private final ColorStyle solidColor;

        SimpleSolidPaint(final Color color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = new ColorStyle(){

                public Color getColor() {
                    return color;
                }

                public int getAlpha() {
                    return -1;
                }

                public int getHueOff() {
                    return -1;
                }

                public int getHueMod() {
                    return -1;
                }

                public int getSatOff() {
                    return -1;
                }

                public int getSatMod() {
                    return -1;
                }

                public int getLumOff() {
                    return -1;
                }

                public int getLumMod() {
                    return -1;
                }

                public int getShade() {
                    return -1;
                }

                public int getTint() {
                    return -1;
                }
            };
        }

        SimpleSolidPaint(ColorStyle colorStyle) {
            if (colorStyle == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = colorStyle;
        }

        public ColorStyle getSolidColor() {
            return this.solidColor;
        }
    }
}

