/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.filesystem.BATManaged;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSDocument;
import ai2.org.apache.poi.poifs.property.RootProperty;
import ai2.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import ai2.org.apache.poi.poifs.storage.SmallDocumentBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat;
    private List<SmallDocumentBlock> _small_blocks;
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(POIFSBigBlockSize pOIFSBigBlockSize, List<OPOIFSDocument> list, RootProperty rootProperty) {
        this._sbat = new BlockAllocationTableWriter(pOIFSBigBlockSize);
        this._small_blocks = new ArrayList<SmallDocumentBlock>();
        this._root = rootProperty;
        for (OPOIFSDocument oPOIFSDocument : list) {
            SmallDocumentBlock[] smallDocumentBlockArray = oPOIFSDocument.getSmallBlocks();
            if (smallDocumentBlockArray.length != 0) {
                oPOIFSDocument.setStartBlock(this._sbat.allocateSpace(smallDocumentBlockArray.length));
                for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
                    this._small_blocks.add(smallDocumentBlockArray[i]);
                }
                continue;
            }
            oPOIFSDocument.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(pOIFSBigBlockSize, this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    @Override
    public int countBlocks() {
        return this._big_block_count;
    }

    @Override
    public void setStartBlock(int n) {
        this._root.setStartBlock(n);
    }

    @Override
    public void writeBlocks(OutputStream outputStream) throws IOException {
        for (BlockWritable blockWritable : this._small_blocks) {
            blockWritable.writeBlocks(outputStream);
        }
    }
}

