/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.storage.BATBlock;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import ai2.org.apache.poi.poifs.storage.HeaderBlockConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class HeaderBlockWriter
implements HeaderBlockConstants,
BlockWritable {
    private final HeaderBlock _header_block;

    public HeaderBlockWriter(POIFSBigBlockSize pOIFSBigBlockSize) {
        this._header_block = new HeaderBlock(pOIFSBigBlockSize);
    }

    public HeaderBlockWriter(HeaderBlock headerBlock) {
        this._header_block = headerBlock;
    }

    public BATBlock[] setBATBlocks(int n, int n2) {
        BATBlock[] bATBlockArray;
        int n3;
        POIFSBigBlockSize pOIFSBigBlockSize = this._header_block.getBigBlockSize();
        this._header_block.setBATCount(n);
        int n4 = Math.min(n, 109);
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = n2 + n3;
        }
        this._header_block.setBATArray(nArray);
        if (n > 109) {
            n3 = n - 109;
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = n2 + i + 109;
            }
            bATBlockArray = BATBlock.createXBATBlocks(pOIFSBigBlockSize, nArray2, n2 + n);
            this._header_block.setXBATStart(n2 + n);
        } else {
            bATBlockArray = BATBlock.createXBATBlocks(pOIFSBigBlockSize, new int[0], 0);
            this._header_block.setXBATStart(-2);
        }
        this._header_block.setXBATCount(bATBlockArray.length);
        return bATBlockArray;
    }

    public void setPropertyStart(int n) {
        this._header_block.setPropertyStart(n);
    }

    public void setSBATStart(int n) {
        this._header_block.setSBATStart(n);
    }

    public void setSBATBlockCount(int n) {
        this._header_block.setSBATBlockCount(n);
    }

    static int calculateXBATStorageRequirements(POIFSBigBlockSize pOIFSBigBlockSize, int n) {
        return n > 109 ? BATBlock.calculateXBATStorageRequirements(pOIFSBigBlockSize, n - 109) : 0;
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        this._header_block.writeData(outputStream);
    }

    public void writeBlock(ByteBuffer byteBuffer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._header_block.getBigBlockSize().getBigBlockSize());
        this._header_block.writeData(byteArrayOutputStream);
        byteBuffer.put(byteArrayOutputStream.toByteArray());
    }
}

