/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.common.POIFSConstants;
import ai2.org.apache.poi.poifs.storage.BigBlock;
import ai2.org.apache.poi.poifs.storage.DataInputBlock;
import ai2.org.apache.poi.poifs.storage.RawDataBlock;
import ai2.org.apache.poi.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class DocumentBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private byte[] _data;
    private int _bytes_read;

    public DocumentBlock(RawDataBlock rawDataBlock) throws IOException {
        super(rawDataBlock.getBigBlockSize() == 512 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS);
        this._data = rawDataBlock.getData();
        this._bytes_read = this._data.length;
    }

    public DocumentBlock(InputStream inputStream, POIFSBigBlockSize pOIFSBigBlockSize) throws IOException {
        this(pOIFSBigBlockSize);
        int n = IOUtils.readFully(inputStream, this._data);
        this._bytes_read = n == -1 ? 0 : n;
    }

    private DocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        super(pOIFSBigBlockSize);
        this._data = new byte[pOIFSBigBlockSize.getBigBlockSize()];
        Arrays.fill(this._data, (byte)-1);
    }

    public int size() {
        return this._bytes_read;
    }

    public boolean partiallyRead() {
        return this._bytes_read != this.bigBlockSize.getBigBlockSize();
    }

    public static byte getFillByte() {
        return -1;
    }

    public static DocumentBlock[] convert(POIFSBigBlockSize pOIFSBigBlockSize, byte[] byArray, int n) {
        DocumentBlock[] documentBlockArray = new DocumentBlock[(n + pOIFSBigBlockSize.getBigBlockSize() - 1) / pOIFSBigBlockSize.getBigBlockSize()];
        int n2 = 0;
        for (int i = 0; i < documentBlockArray.length; ++i) {
            documentBlockArray[i] = new DocumentBlock(pOIFSBigBlockSize);
            if (n2 < byArray.length) {
                int n3 = Math.min(pOIFSBigBlockSize.getBigBlockSize(), byArray.length - n2);
                System.arraycopy(byArray, n2, documentBlockArray[i]._data, 0, n3);
                if (n3 != pOIFSBigBlockSize.getBigBlockSize()) {
                    Arrays.fill(documentBlockArray[i]._data, n3, pOIFSBigBlockSize.getBigBlockSize(), (byte)-1);
                }
            } else {
                Arrays.fill(documentBlockArray[i]._data, (byte)-1);
            }
            n2 += pOIFSBigBlockSize.getBigBlockSize();
        }
        return documentBlockArray;
    }

    public static DataInputBlock getDataInputBlock(DocumentBlock[] documentBlockArray, int n) {
        if (documentBlockArray == null || documentBlockArray.length == 0) {
            return null;
        }
        POIFSBigBlockSize pOIFSBigBlockSize = documentBlockArray[0].bigBlockSize;
        short s = pOIFSBigBlockSize.getHeaderValue();
        int n2 = pOIFSBigBlockSize.getBigBlockSize();
        int n3 = n2 - 1;
        int n4 = n >> s;
        int n5 = n & n3;
        return new DataInputBlock(documentBlockArray[n4]._data, n5);
    }

    void writeData(OutputStream outputStream) throws IOException {
        this.doWriteData(outputStream, this._data);
    }
}

